/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.geom;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class GeomUtils {
    private static final DecimalFormat formatDistance = new DecimalFormat("###0.0");
    private static final DecimalFormat formatCoords = new DecimalFormat("###0.00000");
    private static final double PERTH_LATITUDE = -31.9525739;
    private static final double PERTH_LONGITUDE = 115.8610488;

    public static double formatDistance(double value) {
        return Double.valueOf(formatDistance.format(value));
    }

    public static String formatCoords(double value) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(5, RoundingMode.CEILING);
        return bd.toString();
    }

    public static double distanceToPerthCBD(double lat1, double lng1) {
        return GeomUtils.pointToPointDistance(-31.9525739, 115.8610488, lat1, lng1, new String[0]);
    }

    public static void main(String[] args) {
        System.out.println("Hello World!" + GeomUtils.pointToPointDistance(40.006731, -4.272978, 40.068699, -4.73228, new String[0]));
        System.out.println("Hello World!" + GeomUtils.pointToPointDistance(40.006731, -4.272978, 40.068699, -4.73228, "M"));
    }

    public static double pointToPointDistance(double lat1, double lon1, double lat2, double lon2, String ... unit) {
        String option;
        double theta = lon1 - lon2;
        double deg2rad = Math.PI / 180;
        double rad2deg = 57.29577951308232;
        double dist = Math.sin(lat1 * deg2rad) * Math.sin(lat2 * deg2rad) + Math.cos(lat1 * deg2rad) * Math.cos(lat2 * deg2rad) * Math.cos(theta * deg2rad);
        dist = Math.acos(dist);
        dist *= rad2deg;
        dist = dist * 60.0 * 1.1515;
        switch (option = unit.length != 0 ? unit[0] : "K") {
            case "K": {
                dist *= 1.609344;
                break;
            }
            case "N": {
                dist *= 0.8684;
            }
        }
        return dist;
    }
}

