/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.date;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.lang3.time.DateUtils;

public final class DateUtil {
    private static final SimpleDateFormat SHORT_DATE_FORMAT = new SimpleDateFormat("dd/MM/yy");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    private static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("dd/MM/yyyy hh:mm a");
    private static final SimpleDateFormat FULL_DATE_TIME_FORMAT = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss a");
    private static final SimpleDateFormat MONTH_FULLYEAR_FORMAT = new SimpleDateFormat("MM/yyyy");

    public static String format(Date date) {
        if (date != null) {
            return DATE_FORMAT.format(date);
        }
        return "";
    }

    public static String formatDateTime(Date date) {
        if (date != null) {
            return DATE_TIME_FORMAT.format(date);
        }
        return "";
    }

    public static String formatFullDateTime(Date date) {
        if (date != null) {
            return FULL_DATE_TIME_FORMAT.format(date);
        }
        return "";
    }

    public static String formatToMonthYear(Date date) {
        if (date != null) {
            return MONTH_FULLYEAR_FORMAT.format(date);
        }
        return "";
    }

    public static String formatToShortDate(Date date) {
        if (date != null) {
            return SHORT_DATE_FORMAT.format(date);
        }
        return "";
    }

    public static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
        long diff = date2.getTime() - date1.getTime();
        return timeUnit.convert(diff, TimeUnit.MILLISECONDS);
    }

    public static Date toDate(@NonNull LocalDate localDate) {
        if (localDate == null) {
            throw new NullPointerException("localDate");
        }
        Instant instant = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static Date toDate(@NonNull LocalDateTime localDateTime) {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime");
        }
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static Date toNextDayDate(@NonNull LocalDate localDate) {
        if (localDate == null) {
            throw new NullPointerException("localDate");
        }
        Instant instant = localDate.plusDays(1L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static Calendar toCalendar(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal;
    }

    public static Date startOfDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date endOfDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static boolean containsDay(Date day, Collection<Date> col) {
        return col.stream().anyMatch(col1 -> DateUtils.isSameDay((Date)day, (Date)col1));
    }

    public static Date addWorkingDays(Date d1, int workingDays, Collection<Date> publicHolidays) {
        Calendar c = DateUtil.toCalendar(d1);
        for (int i = 0; i < workingDays; ++i) {
            do {
                c.add(5, 1);
            } while (!DateUtil.containsDay(d1, publicHolidays) && c.get(c.get(7)) == 7 || c.get(7) == 1);
        }
        return c.getTime();
    }

    public static Date getFirstDateOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }

    private DateUtil() {
    }
}

