/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.search;

import com.anahata.util.reflect.AnahataPropertyUtils;
import com.anahata.yam.model.search.ExpandSearch;
import com.anahata.yam.model.search.FullTextCriteria;
import com.anahata.yam.model.search.PojoComparatorFactory;
import com.anahata.yam.model.search.PojoFilter;
import com.anahata.yam.model.search.SearchToken;
import com.anahata.yam.model.search.Searchable;
import java.beans.ConstructorProperties;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoSearch {
    private static final Logger log = LoggerFactory.getLogger(PojoSearch.class);
    private final Object object;
    private final FullTextCriteria criteria;
    private final int depth;
    private final Set<Object> parents;
    private final PojoFilter filter;
    private final PojoComparatorFactory comparatorFactory;
    private double score;
    private Set<SearchToken> matchedTokens;

    public PojoSearch(Object object, FullTextCriteria criteria) {
        this(object, criteria, null, null);
    }

    public PojoSearch(Object object, FullTextCriteria criteria, PojoFilter filter, PojoComparatorFactory comparatorFactory) {
        this.object = object;
        this.criteria = criteria;
        this.depth = 1;
        this.parents = new HashSet<Object>();
        this.matchedTokens = new HashSet<SearchToken>();
        this.filter = filter;
        this.comparatorFactory = comparatorFactory;
        this.process();
    }

    private PojoSearch(Object object, FullTextCriteria criteria, PojoFilter filter, PojoComparatorFactory comparatorFactory, int depth, Set<Object> parents, Set<SearchToken> matchedTokens) {
        Validate.isTrue((!parents.contains(object) ? 1 : 0) != 0);
        this.object = object;
        this.criteria = criteria;
        this.depth = depth;
        this.parents = new HashSet<Object>(parents);
        this.parents.add(object);
        this.matchedTokens = new HashSet<SearchToken>(matchedTokens);
        this.filter = filter;
        this.comparatorFactory = comparatorFactory;
        this.process();
    }

    public boolean matchesAllTokens() {
        return this.matchedTokens.containsAll(this.criteria.getSearchTokens().getPrimalTokens());
    }

    public boolean matches() {
        if (this.score == 0.0) {
            return false;
        }
        return !this.criteria.isMatchAllTokens() || this.matchesAllTokens();
    }

    public static void processList(List list, FullTextCriteria fullTextCriteria, PojoFilter filter, boolean sort, PojoComparatorFactory comparatorFactory) {
        HashMap<Object, Double> scores = new HashMap<Object, Double>();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o != null) {
                PojoSearch pp = new PojoSearch(o, fullTextCriteria, filter, comparatorFactory);
                log.trace("PojoSearch matches ={}. score={} matchedTokens={}", new Object[]{pp.matches(), pp.getScore(), pp.getMatchedTokens()});
                if (pp.matches()) {
                    scores.put(o, pp.getScore());
                    continue;
                }
                it.remove();
                continue;
            }
            it.remove();
        }
        if (list.size() > 1 && sort) {
            Comparator<?> comp;
            if (comparatorFactory != null && (comp = comparatorFactory.getComparator(list.iterator().next().getClass())) != null) {
                Collections.sort(list, comp);
            }
            Collections.sort(list, new ScoreComparator(scores));
        }
    }

    private void add(PojoSearch other) {
        this.score += other.score;
        this.matchedTokens.addAll(other.matchedTokens);
    }

    private void process() {
        log.trace("PojoSearch processing: {}", this.object);
        if (this.filter != null && !this.filter.matches(this.object)) {
            return;
        }
        Class<?> clazz = this.object.getClass();
        HashMap<String, Collection> collections = new HashMap<String, Collection>();
        while (!clazz.equals(Object.class)) {
            for (PropertyDescriptor pd : PropertyUtils.getPropertyDescriptors(clazz)) {
                Collection col;
                PojoSearch pp;
                ExpandSearch fieldTypeExpandSearch;
                ExpandSearch fieldExpandSearch;
                Field f;
                String propertyName = pd.getName();
                log.trace("PojoSearch processing property: {}", (Object)propertyName);
                if (pd.getReadMethod() == null) continue;
                try {
                    f = clazz.getDeclaredField(propertyName);
                }
                catch (NoSuchFieldException | SecurityException e) {
                    continue;
                }
                if (f.isAnnotationPresent(Transient.class) || (fieldExpandSearch = f.getAnnotation(ExpandSearch.class)) != null && !fieldExpandSearch.value() || (fieldTypeExpandSearch = f.getType().getAnnotation(ExpandSearch.class)) != null && !fieldTypeExpandSearch.value() || Collection.class.isAssignableFrom(clazz) && (fieldExpandSearch == null || !fieldExpandSearch.value())) continue;
                log.info("Property {} of object {} qualifies for scoring based on class metadata. Fetching property ", (Object)propertyName, this.object);
                Object propertyValue = AnahataPropertyUtils.getProperty(this.object, pd.getName());
                if (propertyValue == null) continue;
                if (PojoSearch.isSearchableType(propertyValue.getClass())) {
                    if (propertyValue.getClass().isAnnotationPresent(Embeddable.class)) {
                        pp = new PojoSearch(propertyValue, this.criteria, this.filter, this.comparatorFactory, this.depth, new HashSet<Object>(this.parents), this.matchedTokens);
                        this.add(pp);
                        continue;
                    }
                    this.processProperty(propertyName, f.getType(), propertyValue);
                    continue;
                }
                if (!this.criteria.isExpandSearch() || !f.isAnnotationPresent(ExpandSearch.class)) continue;
                if (propertyValue.getClass().isAnnotationPresent(Entity.class)) {
                    if (this.parents.contains(propertyValue)) continue;
                    log.trace("Property {} of object {} is @Entity and expandSearch is enabled. Drilling down.", (Object)propertyName, this.object);
                    pp = new PojoSearch(propertyValue, this.criteria, this.filter, this.comparatorFactory, this.depth + 1, this.parents, this.matchedTokens);
                    this.add(pp);
                    continue;
                }
                if (!(propertyValue instanceof Collection) || (col = (Collection)propertyValue).isEmpty()) continue;
                log.trace("Property {} of object {} is a collection with elements. Adding to collections list to process once all non-collection attributes have been processed.", (Object)propertyName, this.object);
                collections.put(propertyName, col);
            }
            clazz = clazz.getSuperclass();
        }
        for (Map.Entry entry : collections.entrySet()) {
            Comparator<?> comp;
            String propertyName = (String)entry.getKey();
            Collection col = (Collection)entry.getValue();
            log.trace("Processing collection for property {} of object {}.", (Object)propertyName, this.object);
            ArrayList<PojoSearch> childrenProcessors = new ArrayList<PojoSearch>();
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Object child = it.next();
                if (!child.getClass().isAnnotationPresent(Entity.class)) continue;
                if (!this.parents.contains(child)) {
                    PojoSearch pp = new PojoSearch(child, this.criteria, this.filter, this.comparatorFactory, this.depth + 1, this.parents, this.matchedTokens);
                    childrenProcessors.add(pp);
                    continue;
                }
                it.remove();
            }
            HashMap<Object, Double> scores = new HashMap<Object, Double>();
            for (PojoSearch pp : childrenProcessors) {
                if (pp.matches()) {
                    this.add(pp);
                    scores.put(pp.object, pp.getScore());
                    continue;
                }
                col.remove(pp.object);
            }
            if (!(col instanceof List) || col.isEmpty()) continue;
            if (this.comparatorFactory != null && (comp = this.comparatorFactory.getComparator(col.iterator().next().getClass())) != null) {
                Collections.sort((List)col, comp);
            }
            Collections.sort((List)col, new ScoreComparator(scores));
        }
        this.matchedTokens = Collections.unmodifiableSet(this.matchedTokens);
    }

    private void processProperty(String propertyName, Class propertyType, Object propertyValue) {
        boolean treatAsExactMatch;
        String searchableValue = propertyValue instanceof Searchable ? ((Searchable)propertyValue).getValue() : String.valueOf(propertyValue);
        boolean bl = treatAsExactMatch = Long.class.equals((Object)propertyType) || Integer.class.equals((Object)propertyType);
        if (searchableValue != null) {
            searchableValue = searchableValue.toLowerCase();
            double baseScore = 0.0;
            int matchedTokensCount = 0;
            for (SearchToken token : this.criteria.getSearchTokens().getAllTokens()) {
                boolean matches = treatAsExactMatch ? StringUtils.equals((CharSequence)searchableValue, (CharSequence)token.getToken()) : searchableValue.contains(token.getToken());
                if (!matches) continue;
                ++matchedTokensCount;
                this.matchedTokens.add(token);
                if (searchableValue.equals(token.getToken())) {
                    baseScore += (double)(token.getWeight() * 5);
                    continue;
                }
                int points = StringUtils.countMatches((CharSequence)searchableValue, (CharSequence)token.getToken());
                if (searchableValue.startsWith(token.getToken())) {
                    ++points;
                }
                if (searchableValue.startsWith(token.getToken() + " ")) {
                    ++points;
                }
                if (searchableValue.endsWith(" " + token.getToken())) {
                    ++points;
                }
                if (searchableValue.contains(" " + token.getToken() + " ")) {
                    points += StringUtils.countMatches((CharSequence)searchableValue, (CharSequence)(" " + token.getToken() + " "));
                }
                if (log.isTraceEnabled()) {
                    log.trace("token processed. Object:" + this.object + "property=" + propertyName + " propertyValue=" + searchableValue + " Token:" + token + " Token Weight:" + token.getWeight() + " points:" + points);
                }
                baseScore += (double)(token.getWeight() * points);
            }
            if (matchedTokensCount > 0) {
                double propertyScore = baseScore * Math.pow(100.0, matchedTokensCount) / (double)this.depth;
                log.trace("propety score: {} propertyName={}, propertyValue={}, object={}", new Object[]{propertyScore, propertyName, propertyValue, this.object});
                this.score += propertyScore;
            }
        }
    }

    public static boolean isSearchableType(Class type) {
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (String.class.equals((Object)type)) {
            return true;
        }
        if (Searchable.class.isAssignableFrom(type)) {
            return true;
        }
        return type.isAnnotationPresent(Embeddable.class);
    }

    public PojoFilter getFilter() {
        return this.filter;
    }

    public PojoComparatorFactory getComparatorFactory() {
        return this.comparatorFactory;
    }

    public double getScore() {
        return this.score;
    }

    public Set<SearchToken> getMatchedTokens() {
        return this.matchedTokens;
    }

    private static class ScoreComparator
    implements Comparator {
        final Map<Object, Double> scores;

        public int compare(Object o1, Object o2) {
            double diff = this.scores.get(o2) - this.scores.get(o1);
            if (diff > 0.0) {
                return 1;
            }
            if (diff == 0.0) {
                return 0;
            }
            return -1;
        }

        @ConstructorProperties(value={"scores"})
        public ScoreComparator(Map<Object, Double> scores) {
            this.scores = scores;
        }
    }
}

