/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.transport.rpc.client.server;

import com.anahata.util.cdi.Cdi;
import com.anahata.util.transport.ServiceLookupUtils;
import com.anahata.util.transport.rpc.RcpError;
import com.anahata.util.transport.rpc.Rpc;
import com.anahata.util.transport.rpc.RpcStreamer;
import com.anahata.util.validation.ValidationUtils;
import com.anahata.util.web.ServletUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.EJBException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="RpcServlet", urlPatterns={"/rpc/*"})
public class RpcServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(RpcServlet.class);

    public void init() throws ServletException {
        super.init();
    }

    public String getServletInfo() {
        return "Rpc Servlet";
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        long tsEntry = System.currentTimeMillis();
        if (log.isTraceEnabled()) {
            log.trace(ServletUtils.headersToString(request));
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (!req.getMethod().equals("POST")) {
            res.sendError(500, "Rpc Servlet Requires POST");
            PrintWriter out = res.getWriter();
            res.setContentType("text/html");
            out.println("<h1>Rpc Servlet Requires POST</h1>");
            return;
        }
        RpcStreamer streamer = Cdi.get(RpcStreamer.class, new Annotation[0]);
        streamer.init(req);
        Rpc rpc = null;
        Method method = null;
        Serializable ret = null;
        Object exception = null;
        try {
            long tsReceive = System.currentTimeMillis();
            rpc = (Rpc)streamer.receiveStreaming((InputStream)req.getInputStream());
            tsReceive = System.currentTimeMillis() - tsReceive;
            log.trace("Received request: {} in {} ms.", (Object)rpc, (Object)tsReceive);
            Class serviceInterface = rpc.getClazz();
            Object service = ServiceLookupUtils.serviceLookup(serviceInterface);
            Validate.notNull(service, (String)"Could not look up service object for %s", (Object[])new Object[]{serviceInterface});
            method = rpc.getMethod();
            Validate.notNull((Object)method, (String)("Method was null on Rpc " + rpc), (Object[])new Object[0]);
            log.trace("Invoking {} with args {}: ", (Object)method, (Object)rpc.getArgs());
            if (log.isTraceEnabled() && rpc.getArgs() != null) {
                for (Object o : rpc.getArgs()) {
                    log.trace("args type for {} = {} ", o, o != null ? o.getClass() : " <none>");
                }
            }
            long tsInvoke = System.currentTimeMillis();
            ret = (Serializable)method.invoke(service, rpc.getArgs());
            tsInvoke = System.currentTimeMillis() - tsInvoke;
            log.trace("Invocation of {} took {} ms.", (Object)method, (Object)tsInvoke);
        }
        catch (Throwable e) {
            Throwable cause = e;
            String s = ValidationUtils.getConstraintValidationDetails(e);
            if (s == null) {
                s = " ";
            }
            log.error("Exception caught from service invocation " + s, e);
            while ((cause instanceof InvocationTargetException || cause instanceof EJBException) && cause.getCause() != null) {
                log.debug("Unwrapping {}", (Object)e.toString());
                cause = cause.getCause();
            }
            log.debug("Creating throwable for {}", (Object)cause.toString());
            ret = new RcpError(cause);
        }
        try {
            HttpServletResponse httpResp = (HttpServletResponse)response;
            httpResp.setHeader("Content-Type", "application/octet-stream");
            streamer.stream((Object)ret, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error("Exception serializing response from " + rpc, (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        tsEntry = System.currentTimeMillis() - tsEntry;
        log.trace("RpcServlet took {} for {}.", new Object[]{tsEntry, method, method});
    }
}

