/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.transport.rpc;

import com.anahata.util.config.internal.AnahataUtilConfig;
import com.anahata.util.hessian.HessianUtils;
import com.anahata.util.io.AnahataCompressionUtils;
import com.anahata.util.io.AnahataSerializationUtils;
import com.anahata.util.io.CompressionType;
import com.anahata.util.io.SerializationType;
import com.anahata.util.lang.BasicThreadFactory;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import de.javakaffee.kryoserializers.GregorianCalendarSerializer;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import de.javakaffee.kryoserializers.cglib.CGLibProxySerializer;
import de.javakaffee.kryoserializers.jodatime.JodaDateTimeSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.eclipse.persistence.jpa.jpql.parser.DateTime;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class RpcStreamer {
    private static final Logger log = LoggerFactory.getLogger(RpcStreamer.class);
    @Inject
    private AnahataUtilConfig config;
    private SerializationType serializationType;
    private CompressionType compressionType;
    private Kryo kryo = new Kryo();
    private CompressorStreamFactory compressorStreamFactory = new CompressorStreamFactory();
    private static ExecutorService streamerPool = Executors.newCachedThreadPool(new BasicThreadFactory("RpcStreamer", true, 5));

    public RpcStreamer() {
        this.kryo.setAsmEnabled(true);
        this.kryo.setRegistrationRequired(false);
        this.kryo.setInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
        this.kryo.register(Arrays.asList("").getClass(), (Serializer)new ArraysAsListSerializer());
        this.kryo.register(Collections.EMPTY_LIST.getClass(), (Serializer)new DefaultSerializers.CollectionsEmptyListSerializer());
        this.kryo.register(Collections.EMPTY_MAP.getClass(), (Serializer)new DefaultSerializers.CollectionsEmptyMapSerializer());
        this.kryo.register(Collections.EMPTY_SET.getClass(), (Serializer)new DefaultSerializers.CollectionsEmptySetSerializer());
        this.kryo.register(Collections.singletonList("").getClass(), (Serializer)new DefaultSerializers.CollectionsSingletonListSerializer());
        this.kryo.register(Collections.singleton("").getClass(), (Serializer)new DefaultSerializers.CollectionsSingletonSetSerializer());
        this.kryo.register(Collections.singletonMap("", "").getClass(), (Serializer)new DefaultSerializers.CollectionsSingletonMapSerializer());
        this.kryo.register(GregorianCalendar.class, (Serializer)new GregorianCalendarSerializer());
        this.kryo.register(InvocationHandler.class, (Serializer)new JdkProxySerializer());
        UnmodifiableCollectionsSerializer.registerSerializers((Kryo)this.kryo);
        SynchronizedCollectionsSerializer.registerSerializers((Kryo)this.kryo);
        this.kryo.register(CGLibProxySerializer.CGLibProxyMarker.class, (Serializer)new CGLibProxySerializer());
        this.kryo.register(DateTime.class, (Serializer)new JodaDateTimeSerializer());
    }

    @PostConstruct
    private void init() {
        this.serializationType = this.config.getRpcSerialization();
        this.compressionType = this.config.getRpcCompression();
    }

    public void init(HttpServletRequest request) {
        SerializationType reqSerializationType;
        CompressionType reqCompressionType = AnahataCompressionUtils.readHeader(request);
        if (reqCompressionType != null) {
            this.compressionType = reqCompressionType;
        }
        if ((reqSerializationType = AnahataSerializationUtils.readHeader(request)) != null) {
            this.serializationType = reqSerializationType;
        }
    }

    public long getCompressedSize(Object ... objects) throws IOException, CompressorException {
        return this.stream(objects).length;
    }

    public long getSerializedSize(Object ... objects) throws IOException, CompressorException {
        return this.serialize(objects).length;
    }

    public byte[] stream(Object o) throws IOException, CompressorException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStream compressingOS = this.newCompressingOutputStream(baos);){
            this.serialize(o, compressingOS);
        }
        return baos.toByteArray();
    }

    public InputStream streamToInputStream(final Object o) throws IOException, CompressorException {
        PipedInputStream in = new PipedInputStream();
        final PipedOutputStream out = new PipedOutputStream(in);
        streamerPool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    RpcStreamer.this.stream(o, out);
                }
                catch (IOException | CompressorException e) {
                    log.error("Exception streaming {}", o, (Object)e);
                }
            }
        });
        return in;
    }

    public byte[] serialize(Object o) throws IOException, CompressorException {
        long ts = System.currentTimeMillis();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.serialize(o, baos);
        byte[] ret = baos.toByteArray();
        ts = System.currentTimeMillis() - ts;
        log.trace("{} serialized size : {}, took {}", new Object[]{this.toString(), ret.length, ts});
        return ret;
    }

    public void serialize(Object o, OutputStream baos) throws IOException, CompressorException {
        if (this.serializationType == SerializationType.JAVA) {
            SerializationUtils.serialize((Serializable)((Serializable)o), (OutputStream)baos);
        } else if (this.serializationType == SerializationType.KRYO) {
            try (Output out = new Output(baos);){
                this.kryo.writeClassAndObject(out, o);
            }
        } else if (this.serializationType == SerializationType.HESSIAN) {
            HessianUtils.serialize(o, baos);
        } else {
            throw new IllegalArgumentException("serializationType " + (Object)((Object)this.serializationType) + " not supported");
        }
    }

    public byte[] compress(byte[] source) throws IOException, CompressorException {
        long ts = System.currentTimeMillis();
        if (this.compressionType == CompressionType.NONE) {
            return source;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStream os = this.newCompressingOutputStream(baos);){
            IOUtils.write((byte[])source, (OutputStream)os);
            os.flush();
        }
        byte[] ret = baos.toByteArray();
        if (log.isDebugEnabled()) {
            BigDecimal ratio = new BigDecimal(100.0f * ((float)ret.length / (float)source.length));
            ratio = ratio.setScale(2, RoundingMode.HALF_UP);
            log.trace("{} compression: source={}, compressed={}, ratio={}%", new Object[]{this.toString(), source.length, ret.length, ratio});
            if (ratio.intValue() > 100) {
                log.trace("{} compression made data bigger: source={}, compressed={}, ratio={}%", new Object[]{this.toString(), source.length, ret.length, ratio});
            }
        }
        ts = System.currentTimeMillis() - ts;
        log.trace("Compression took {}", (Object)ts);
        return ret;
    }

    public byte[] uncompress(byte[] source) throws IOException, CompressorException {
        long ts = System.currentTimeMillis();
        if (this.compressionType == CompressionType.NONE) {
            return source;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(source);
        InputStream is = this.newUncompressingInputStream(bais);
        byte[] ret = IOUtils.toByteArray((InputStream)is);
        ts = System.currentTimeMillis() - ts;
        log.trace("{} decompressed size : {}, took {} ms.", new Object[]{this.toString(), ret.length, ts});
        return ret;
    }

    public void stream(Object o, OutputStream os) throws IOException, CompressorException {
        os = this.newCompressingOutputStream(os);
        this.serialize(o, os);
        os.close();
    }

    public void send(Object o, OutputStream os) throws IOException, CompressorException {
        if (this.compressionType == CompressionType.NONE) {
            this.serialize(o, os);
        } else {
            long ts = System.currentTimeMillis();
            byte[] data = this.serialize(o);
            data = this.compress(data);
            IOUtils.write((byte[])data, (OutputStream)os);
            ts = System.currentTimeMillis() - ts;
            log.debug("serialization, compression and writing {} :took {}", (Object)this.toString(), (Object)ts);
        }
    }

    public <T> T uncompressDeserialize(byte[] data) throws IOException, CompressorException {
        data = this.uncompress(data);
        return this.deserialize(data);
    }

    public <T> T receive(InputStream is) throws IOException, CompressorException {
        return this.uncompressDeserialize(IOUtils.toByteArray((InputStream)is));
    }

    public void stream(Object o, BytesMessage message) throws IOException, CompressorException, JMSException {
        message.setStringProperty("AnahataCompression", this.getCompressionType().name());
        message.setStringProperty("AnahataSerialization", this.getSerializationType().name());
        byte[] data = this.stream(o);
        log.debug("streamed object {}: writing {} bytes to message", o, (Object)data.length);
        message.writeBytes(data);
    }

    public <T> T receive(BytesMessage message) throws JMSException, IOException, CompressorException {
        CompressionType compression = AnahataCompressionUtils.readHeader((Message)message);
        SerializationType serialization = AnahataSerializationUtils.readHeader((Message)message);
        this.setCompressionType(compression);
        this.setSerializationType(serialization);
        BytesMessage bytesMessage = message;
        log.trace("BodyLength: {}", (Object)bytesMessage.getBodyLength());
        byte[] barr = new byte[(int)bytesMessage.getBodyLength()];
        bytesMessage.readBytes(barr);
        log.trace("received bytes {} ", (Object)barr);
        return this.uncompressDeserialize(barr);
    }

    public <T> T receiveStreaming(InputStream is) throws IOException, CompressorException {
        is = this.newUncompressingInputStream(is);
        return this.deserialize(is);
    }

    public <T> T deserialize(InputStream is) throws IOException, CompressorException {
        Object ret;
        long ts = System.currentTimeMillis();
        if (this.serializationType == SerializationType.JAVA) {
            ret = SerializationUtils.deserialize((InputStream)is);
        } else if (this.serializationType == SerializationType.KRYO) {
            try (Input input = new Input(is);){
                ret = this.kryo.readClassAndObject(input);
            }
        } else if (this.serializationType == SerializationType.HESSIAN) {
            ret = HessianUtils.deSerialize(is);
        } else {
            throw new IllegalArgumentException("serializationType " + (Object)((Object)this.serializationType) + " not supported");
        }
        ts = System.currentTimeMillis() - ts;
        log.trace("deserialization {} took {}", (Object)this.toString(), (Object)ts);
        return (T)ret;
    }

    public <T> T deserialize(byte[] data) throws IOException, CompressorException {
        return this.deserialize(new ByteArrayInputStream(data));
    }

    public Object roundTrip(Object o) throws IOException, CompressorException {
        long ts = System.currentTimeMillis();
        byte[] b = this.stream(o);
        Object ret = this.uncompressDeserialize(b);
        ts = System.currentTimeMillis() - ts;
        log.debug("{} roundtrip took {}, size: {}", new Object[]{this.toString(), ts, b.length});
        return ret;
    }

    private InputStream newUncompressingInputStream(InputStream is) throws CompressorException {
        if (CompressionType.NONE != this.compressionType) {
            is = CompressionType.DEFLATE == this.compressionType ? new InflaterInputStream(is) : this.compressorStreamFactory.createCompressorInputStream(this.compressionType.name(), is);
        }
        log.trace("InputStream: {}", (Object)is.getClass().getSimpleName());
        return is;
    }

    private OutputStream newCompressingOutputStream(OutputStream os) throws CompressorException {
        if (CompressionType.NONE != this.compressionType) {
            os = CompressionType.DEFLATE == this.compressionType ? new DeflaterOutputStream(os, new Deflater(9)) : this.compressorStreamFactory.createCompressorOutputStream(this.compressionType.name(), os);
        }
        return os;
    }

    public String toString() {
        return this.getClass().getSimpleName() + (Object)((Object)this.serializationType) + "/" + (Object)((Object)this.compressionType);
    }

    public void setSerializationType(SerializationType serializationType) {
        this.serializationType = serializationType;
    }

    public SerializationType getSerializationType() {
        return this.serializationType;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }
}

