/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.redundant;

import com.anahata.util.progress.ProgressListener;
import com.anahata.util.redundant.RedundantTaskException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedundantTask<T>
implements ProgressListener {
    private static final Logger log = LoggerFactory.getLogger(RedundantTask.class);
    private static final ThreadLocal<RedundantTask> threadLocal = new ThreadLocal();
    private final Set<Thread> threads = new HashSet<Thread>();
    protected boolean started = false;
    protected boolean suceeded = false;
    protected boolean failed = false;
    protected boolean aborted = false;
    protected double progress = -2.0;
    protected T value;
    private ProgressListener progressListener;
    protected List<Callable<T>> callables = new ArrayList<Callable<T>>();
    protected final List<Throwable> errors = new ArrayList<Throwable>();
    private ExecutorService executorService;

    public RedundantTask(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public RedundantTask(ExecutorService executorService, ProgressListener pl) {
        this(executorService);
        this.progressListener = pl;
    }

    public boolean isFinished() {
        return this.suceeded || this.failed || this.aborted;
    }

    @Override
    public void progress(double progress) {
        if (progress > this.progress) {
            this.progress = progress;
            if (this.progressListener != null) {
                this.progressListener.progress(this.progress);
            }
        }
    }

    public void addCallable(Callable<T> callable) {
        this.callables.add(callable);
    }

    public synchronized T getOrFail(String message) throws RedundantTaskException {
        log.trace("getOrFail() entry");
        T ret = this.get(true);
        log.trace("getOrFail() got {}, failed={}, aborted-{}", new Object[]{String.valueOf(ret), this.failed, this.aborted});
        if (this.failed) {
            throw new RedundantTaskException("Task failed: " + message, this.getErrors());
        }
        if (this.aborted) {
            throw new RedundantTaskException("Task aborted: " + message, this.getErrors());
        }
        log.trace("getOrFail() returning {}", (Object)String.valueOf(ret));
        return ret;
    }

    public synchronized T get(boolean wait) {
        if (this.isFinished()) {
            return this.value;
        }
        log.trace("get (wait = {}) entry", (Object)wait);
        if (!this.started) {
            log.trace("get() called and race not started, starting");
            this.start();
            log.trace("get() called race started");
        }
        if (!this.isFinished() && !this.isAborted() && wait) {
            try {
                log.trace("get() will now wait");
                this.wait();
                log.trace("get() woke up from waiting");
            }
            catch (InterruptedException e) {
                throw new RuntimeException("get(wait = true) interrupted", e);
            }
        }
        log.trace("get() returning {}", (Object)String.valueOf(this.value));
        return this.value;
    }

    public synchronized boolean isRunning() {
        return this.started && !this.suceeded && !this.failed && !this.aborted;
    }

    public synchronized void start() {
        Validate.isTrue((!this.started ? 1 : 0) != 0, (String)"task already started", (Object[])new Object[0]);
        this.started = true;
        this.execute();
    }

    public synchronized void abort() {
        this.aborted = true;
        this.notify();
        this.interruptThreads();
    }

    protected synchronized void suceeded(T t) {
        log.trace("{} entering succeeded", (Object)Thread.currentThread());
        if (!this.suceeded) {
            this.suceeded = true;
            this.value = t;
            this.interruptThreads();
            this.progress(1.0);
            this.notify();
        }
        log.trace("{} exiting succeeded", (Object)Thread.currentThread());
        this.unregisterThread();
    }

    protected synchronized void registerError(Throwable e) {
        this.errors.add(e);
    }

    protected synchronized void fail() {
        log.debug("Redundant task fail()");
        this.failed = true;
        log.debug("Redundant task fail() calling interruptingThreads()");
        this.interruptThreads();
        log.debug("Redundant task fail() calling notify()");
        this.notify();
        log.debug("Redundant task fail() exiting");
    }

    protected void submit(final Runnable r) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (!RedundantTask.this.isRunning()) {
                    log.debug("Not running: {}", (Object)r);
                    return;
                }
                RedundantTask.this.registerThread();
                try {
                    r.run();
                }
                catch (Throwable e) {
                    log.error("UncaughtException in submitted runnable", e);
                }
                RedundantTask.this.unregisterThread();
            }
        });
    }

    protected abstract void execute();

    private void interruptThreads() {
        for (Thread activeThread : this.threads) {
            log.debug("Interrupting {}", (Object)activeThread);
            activeThread.interrupt();
        }
    }

    private synchronized void registerThread() {
        log.debug("Registering {}", (Object)Thread.currentThread());
        threadLocal.set(this);
        this.threads.add(Thread.currentThread());
        log.trace("{} Registered", (Object)Thread.currentThread());
    }

    private synchronized void unregisterThread() {
        log.debug("Unregistering {}", (Object)Thread.currentThread());
        threadLocal.set(null);
        this.threads.remove(Thread.currentThread());
        log.trace("{} Unregistered", (Object)Thread.currentThread());
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isSuceeded() {
        return this.suceeded;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public double getProgress() {
        return this.progress;
    }

    public List<Callable<T>> getCallables() {
        return this.callables;
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }
}

