/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.mime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;

public final class MimeUtils {
    public static final Set<String> COMPRESSED_MIME_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("image/jpeg", "image/jpg", "image/gif", "image/png", "application/x-compress", "application/x-compressed", "application/x-zip-compressed", "application/zip", "multipart/x-zip", "application/x-rar-compressed", "application/x-bzip", "application/x-bzip2")));

    public static String getMimeType(File file) throws IOException {
        Validate.notNull((Object)file, (String)"File is required", (Object[])new Object[0]);
        DefaultDetector dd = new DefaultDetector();
        Metadata m = new Metadata();
        m.set("resourceName", file.getName());
        try (TikaInputStream is = TikaInputStream.get((File)file);){
            String string = dd.detect((InputStream)is, m).toString();
            return string;
        }
    }

    public static String getMimeType(byte[] data, String fileName) throws IOException {
        Validate.notNull((Object)data, (String)"data is required", (Object[])new Object[0]);
        Validate.notNull((Object)fileName, (String)"File name is required", (Object[])new Object[0]);
        DefaultDetector dd = new DefaultDetector();
        Metadata m = new Metadata();
        m.set("resourceName", fileName);
        try (TikaInputStream is = TikaInputStream.get((InputStream)new ByteArrayInputStream(data));){
            String string = dd.detect((InputStream)is, m).toString();
            return string;
        }
    }

    public static boolean isCompressed(String mimeType) {
        return COMPRESSED_MIME_TYPES.contains(mimeType.toLowerCase());
    }

    public static boolean isCompressed(File file) throws IOException {
        return MimeUtils.isCompressed(MimeUtils.getMimeType(file));
    }

    private MimeUtils() {
    }
}

