/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.lang;

import com.anahata.util.lang.Nvl;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class AnahataStringUtils {
    public static String digitsOnly(String string) {
        Validate.notNull((Object)string, (String)"The stringarray is empty", (Object[])new Object[0]);
        StringBuilder ret = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static String lettersOnly(String string) {
        Validate.notNull((Object)string, (String)"The stringarray is empty", (Object[])new Object[0]);
        StringBuilder ret = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (!Character.isAlphabetic(c)) continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static boolean isAllEmpty(String ... strings) {
        Validate.isTrue((strings.length > 0 ? 1 : 0) != 0, (String)"The string array is empty", (Object[])new Object[0]);
        for (String string : strings) {
            if (StringUtils.isEmpty((CharSequence)string)) continue;
            return false;
        }
        return true;
    }

    public static String removeIgnoreCase(String str, String remove) {
        int index = StringUtils.indexOfIgnoreCase((CharSequence)str, (CharSequence)remove);
        if (index < 0) {
            return str;
        }
        return str.substring(0, index) + str.substring(index + remove.length());
    }

    public static List<String> getCommonPrefixes(List<String> strs, Integer minMatch) {
        if (strs == null) {
            return Collections.emptyList();
        }
        int size = strs.size();
        WeightedWords weightings = AnahataStringUtils.getWeightings(strs, minMatch);
        int totalWeight = weightings.getTotalWeight();
        while (totalWeight > size) {
            size = weightings.size();
            weightings = AnahataStringUtils.getWeightings(weightings.getWords(), minMatch);
            totalWeight = weightings.getTotalWeight();
        }
        return weightings.getWords();
    }

    public static String replaceChars(String source, char[] charsToBeReplaced, String replacement) {
        Validate.notNull((Object)source, (String)"source is required", (Object[])new Object[0]);
        Validate.notNull((Object)charsToBeReplaced, (String)"charsToBeReplaced is required", (Object[])new Object[0]);
        Validate.notNull((Object)replacement, (String)"replacement is required", (Object[])new Object[0]);
        String ret = source;
        for (char c : charsToBeReplaced) {
            ret = ret.replace(String.valueOf(c), replacement);
        }
        return ret;
    }

    public static String replaceFirstIgnoreCase(String str, String prefix, String replacement) {
        if (prefix != null && StringUtils.startsWithIgnoreCase((CharSequence)str, (CharSequence)prefix)) {
            return replacement + str.substring(prefix.length());
        }
        return str;
    }

    public static String capitilizeNext(String str, String search) {
        if (str == null || search == null) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int mcPos = str.indexOf(search);
        while (mcPos >= 0) {
            int end = mcPos + search.length();
            sb.append(str.substring(start, end));
            sb.append(str.substring(end, end + 1).toUpperCase());
            start = end + 1;
            mcPos = str.indexOf(search, start);
        }
        sb.append(str.substring(start));
        return sb.toString();
    }

    public static String replaceEachIgnoreCase(String text, String[] searchList, String[] replacementList) {
        if (text == null || searchList == null || replacementList == null || searchList.length == 0 || replacementList.length == 0) {
            return text;
        }
        Validate.isTrue((searchList.length == replacementList.length ? 1 : 0) != 0, (String)"The searchList and replacementList params must be equal in length, they were %d and %d", (Object[])new Object[]{searchList.length, replacementList.length});
        for (int i = 0; i < searchList.length; ++i) {
            String search = searchList[i];
            int searchLength = search.length();
            String replace = replacementList[i];
            int pos = StringUtils.indexOfIgnoreCase((CharSequence)text, (CharSequence)search);
            while (pos >= 0) {
                text = text.substring(0, pos) + replace + text.substring(pos + searchLength);
                pos = StringUtils.indexOfIgnoreCase((CharSequence)text, (CharSequence)search, (int)(pos + searchLength));
            }
        }
        return text;
    }

    public static List<String> split(String s, String pattern) {
        assert (s != null);
        assert (pattern != null);
        return AnahataStringUtils.split(s, Pattern.compile(pattern));
    }

    public static List<String> split(String s, Pattern pattern) {
        assert (s != null);
        assert (pattern != null);
        Matcher m = pattern.matcher(s);
        ArrayList<String> ret = new ArrayList<String>();
        int start = 0;
        while (m.find()) {
            ret.add(s.substring(start, m.start()));
            ret.add(m.group());
            start = m.end();
        }
        ret.add(start >= s.length() ? "" : s.substring(start));
        return ret;
    }

    public static int compareToIgnoreCase(String str1, String str2) {
        return AnahataStringUtils.compareToIgnoreCase(str1, str2, false);
    }

    public static int compareToIgnoreCase(String str1, String str2, boolean nullGreater) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null) {
            return nullGreater ? 1 : -1;
        }
        if (str2 == null) {
            return nullGreater ? -1 : 1;
        }
        return str1.compareToIgnoreCase(str2);
    }

    private static WeightedWords getWeightings(List<String> strs, Integer minMatch) {
        HashSet<String> prefixes = new HashSet<String>();
        int size = strs.size();
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                String prefix = StringUtils.getCommonPrefix((String[])new String[]{strs.get(i).toUpperCase(), strs.get(j).toUpperCase()});
                if (StringUtils.isBlank((CharSequence)prefix) || minMatch != null && prefix.length() < minMatch) continue;
                prefixes.add(prefix);
            }
        }
        ArrayList<String> unmatched = new ArrayList<String>(strs);
        Iterator i = unmatched.iterator();
        block2: while (i.hasNext()) {
            String str = (String)i.next();
            for (String prefix : prefixes) {
                if (!str.toUpperCase().startsWith(prefix.toUpperCase())) continue;
                i.remove();
                continue block2;
            }
        }
        prefixes.addAll(unmatched);
        WeightedWords result = new WeightedWords();
        for (String prefix : prefixes) {
            result.add(AnahataStringUtils.countMatches(strs, prefix));
        }
        return result;
    }

    private static WeightedWord countMatches(List<String> strs, String prefix) {
        int count = 0;
        for (String str : strs) {
            if (!str.toUpperCase().startsWith(prefix.toUpperCase())) continue;
            ++count;
        }
        return new WeightedWord(prefix, count);
    }

    public static String toJavaPropertyName(String source, String splitToken) {
        if (source == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(source.length());
        for (String word : source.split(splitToken)) {
            if (word.isEmpty()) continue;
            String firstChar = word.substring(0, 1);
            if (ret.length() > 0) {
                firstChar = firstChar.toUpperCase();
            }
            ret.append(firstChar);
            ret.append(word.substring(1).toLowerCase());
        }
        return ret.toString();
    }

    public static int getLevenshteinDistancePctg(String s, String t) {
        int i;
        s = Nvl.nvl(s);
        t = Nvl.nvl(t);
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        double levNum = p[n];
        double percent = levNum / (double)Math.max(s.length(), t.length()) * 100.0;
        int percentDiff = (int)percent;
        return percentDiff;
    }

    public static boolean endsWithAnyIgnoreCase(CharSequence string, CharSequence ... searchStrings) {
        if (StringUtils.isEmpty((CharSequence)string) || ArrayUtils.isEmpty((Object[])searchStrings)) {
            return false;
        }
        for (CharSequence searchString : searchStrings) {
            if (!StringUtils.endsWithIgnoreCase((CharSequence)string, (CharSequence)searchString)) continue;
            return true;
        }
        return false;
    }

    private AnahataStringUtils() {
    }

    private static class WeightedWord
    implements Comparable<WeightedWord> {
        private String word;
        private Integer weight;

        @Override
        public int compareTo(WeightedWord o) {
            int result = o.weight.compareTo(this.weight);
            if (result == 0) {
                result = this.word.compareTo(o.word);
            }
            return result;
        }

        public String toString() {
            return this.word + "\t" + this.weight;
        }

        @ConstructorProperties(value={"word", "weight"})
        public WeightedWord(String word, Integer weight) {
            this.word = word;
            this.weight = weight;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WeightedWord)) {
                return false;
            }
            WeightedWord other = (WeightedWord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$word = this.getWord();
            String other$word = other.getWord();
            if (this$word == null ? other$word != null : !this$word.equals(other$word)) {
                return false;
            }
            Integer this$weight = this.getWeight();
            Integer other$weight = other.getWeight();
            return !(this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WeightedWord;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $word = this.getWord();
            result = result * 59 + ($word == null ? 0 : $word.hashCode());
            Integer $weight = this.getWeight();
            result = result * 59 + ($weight == null ? 0 : ((Object)$weight).hashCode());
            return result;
        }

        public String getWord() {
            return this.word;
        }

        public Integer getWeight() {
            return this.weight;
        }
    }

    private static class WeightedWords {
        private SortedSet<WeightedWord> wws = new TreeSet<WeightedWord>();

        private WeightedWords() {
        }

        public void add(WeightedWord ww) {
            this.wws.add(ww);
        }

        public List<String> getWords() {
            ArrayList<String> result = new ArrayList<String>(this.wws.size());
            for (WeightedWord ww : this.wws) {
                result.add(ww.getWord());
            }
            return result;
        }

        public int getTotalWeight() {
            int total = 0;
            for (WeightedWord ww : this.wws) {
                total += ww.getWeight().intValue();
            }
            return total;
        }

        public int size() {
            return this.wws.size();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (WeightedWord ww : this.wws) {
                if (first) {
                    first = false;
                } else {
                    sb.append('\n');
                }
                sb.append(ww.getWord());
                sb.append('\t');
                sb.append(ww.getWeight());
            }
            return sb.toString();
        }
    }
}

