/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jpa;

import com.anahata.util.jpa.JPAAnnotationUtils;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.sessions.CopyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JPAUtils {
    private static final Logger log = LoggerFactory.getLogger(JPAUtils.class);

    public static <T> T save(EntityManager em, T entity) {
        Validate.notNull(entity, (String)"can not save null entity", (Object[])new Object[0]);
        Object id = em.getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(entity);
        if (id == null) {
            em.persist(entity);
        } else {
            entity = em.merge(entity);
        }
        return entity;
    }

    public static <T> TypedQuery<T> selectAll(EntityManager em, Class<T> entity) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(entity);
        Root from = cq.from(entity);
        CriteriaQuery select = cq.select((Selection)from);
        TypedQuery typedQuery = em.createQuery(select);
        return typedQuery;
    }

    public static TypedQuery<Long> selectCountAll(EntityManager entityManager, Class<?> entity) {
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root from = criteriaQuery.from(entity);
        CriteriaQuery select = criteriaQuery.select((Selection)criteriaBuilder.count((Expression)from));
        TypedQuery typedQuery = entityManager.createQuery(select);
        return typedQuery;
    }

    public static <A, T extends A> TypedQuery<T> findByField(EntityManager entityManager, Class<T> entity, SingularAttribute<A, ?> attribute, Object ... values) {
        return JPAUtils.findByField(entityManager, entity, attribute, null, false, values);
    }

    public static <A, T extends A> TypedQuery<T> findByField(EntityManager entityManager, Class<T> entity, SingularAttribute<A, ?> attribute, List values) {
        return JPAUtils.findByField(entityManager, entity, attribute, null, false, values.toArray());
    }

    public static <A, T extends A> boolean hasDuplicate(EntityManager entityManager, T candidate, Class<T> entity, SingularAttribute<A, ?> attribute, Object ... values) {
        List ret = JPAUtils.findByField(entityManager, entity, attribute, null, false, values).setMaxResults(2).getResultList();
        if (ret.size() > 1) {
            return true;
        }
        return ret.size() == 1 && !Objects.equals(candidate, ret.get(0));
    }

    public static <A, T extends A, V> TypedQuery<T> findByField(EntityManager entityManager, Class<T> entity, SingularAttribute<A, V> attribute, SingularAttribute<A, V> orderBy, boolean asc, Object ... values) {
        return JPAUtils.findByFieldSorted(entityManager, entity, attribute, orderBy, asc, values);
    }

    public static <A, T extends A, V> TypedQuery<T> findByFieldSorted(EntityManager entityManager, Class<T> entity, SingularAttribute<A, V> attribute, SingularAttribute<A, V> orderBy, boolean asc, Object ... values) {
        Validate.notNull((Object)values, (String)"Values can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)entityManager, (String)"entityManager can not be null", (Object[])new Object[0]);
        Validate.notNull(entity, (String)"entity can not be null", (Object[])new Object[0]);
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(entity);
        Root from = criteriaQuery.from(entity);
        if (values.length > 1) {
            criteriaQuery.where((Expression)from.get(attribute).in(Arrays.asList(values)));
        } else if (values.length > 0) {
            criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)from.get(attribute), values[0]));
        }
        CriteriaQuery select = criteriaQuery.select((Selection)from);
        if (orderBy != null) {
            if (asc) {
                select.orderBy(new Order[]{criteriaBuilder.asc((Expression)from.get(orderBy))});
            } else {
                select.orderBy(new Order[]{criteriaBuilder.desc((Expression)from.get(orderBy))});
            }
        }
        TypedQuery typedQuery = entityManager.createQuery(select);
        return typedQuery;
    }

    @Deprecated
    public static <A, T extends A> TypedQuery<T> findByField(EntityManager entityManager, Class<T> entity, SingularAttribute<A, ?> attribute, Object value, SingularAttribute<A, ?> orderBy, boolean asc) {
        return JPAUtils.findByField(entityManager, entity, orderBy, new Object[]{attribute, asc, value});
    }

    public static Object getManaged(EntityManager em, Object entity, LockModeType lockMode) throws IntrospectionException, NoSuchFieldException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Validate.notNull((Object)em);
        Object managed = entity;
        if (entity != null) {
            managed = entity instanceof Collection ? JPAUtils.getManagedEntityCollection(em, (Collection)entity, lockMode) : (entity.getClass().isArray() ? JPAUtils.getManagedEntityArray(em, entity, lockMode) : JPAUtils.getManagedEntity(em, entity, lockMode));
        }
        return managed;
    }

    private static Collection getManagedEntityCollection(EntityManager em, Collection col, LockModeType lockMode) throws IntrospectionException, NoSuchFieldException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (col.isEmpty()) {
            return col;
        }
        Object[] arr = col.toArray();
        arr = JPAUtils.getManagedEntityArray(em, arr, lockMode);
        col.clear();
        col.addAll(Arrays.asList(arr));
        return col;
    }

    private static Object[] getManagedEntityArray(EntityManager em, Object[] arr, LockModeType lockMode) throws IntrospectionException, NoSuchFieldException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] ret = new Object[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            ret[i] = JPAUtils.getManagedEntity(em, arr[i], lockMode);
        }
        return ret;
    }

    private static Object getManagedEntity(EntityManager em, Object entity, LockModeType lockMode) throws IntrospectionException, NoSuchFieldException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object managed = entity;
        if (entity != null && JPAAnnotationUtils.isEntity(entity.getClass())) {
            Object id = em.getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(entity);
            if (id == null) {
                throw new IllegalArgumentException("The ID for the given entity has not been set. Cannot convert to a managed entity: " + entity);
            }
            managed = em.find(entity.getClass(), id, lockMode);
        }
        return managed;
    }

    public static <T> T copy(EntityManager em, CopyGroup cg, T object) {
        if (em.isJoinedToTransaction()) {
            log.debug("Flushing before copy");
            em.flush();
        } else {
            log.trace("Not flushing before copy");
        }
        return (T)((JpaEntityManager)em.unwrap(JpaEntityManager.class)).copy(object, (AttributeGroup)cg);
    }

    public static <T> List<T> copy(EntityManager em, CopyGroup cg, List<T> objects) {
        if (em.isJoinedToTransaction()) {
            log.debug("Flushing before copy");
            em.flush();
        } else {
            log.trace("Not flushing before copy");
        }
        return (List)((JpaEntityManager)em.unwrap(JpaEntityManager.class)).copy(objects, (AttributeGroup)cg);
    }

    public static <T> List<T> copyOneByOne(EntityManager em, CopyGroup cg, List<T> objects) {
        ArrayList<T> ret = new ArrayList<T>();
        for (T t : objects) {
            log.trace("Copying {}", t);
            T copy = JPAUtils.copy(em, cg, t);
            log.trace("Copy = {}", copy);
            ret.add(copy);
        }
        return ret;
    }

    public static <T> void deleteById(@NonNull EntityManager em, @NonNull Class<T> entityClass, @NonNull Object primaryKey) {
        if (em == null) {
            throw new NullPointerException("em");
        }
        if (entityClass == null) {
            throw new NullPointerException("entityClass");
        }
        if (primaryKey == null) {
            throw new NullPointerException("primaryKey");
        }
        Object entity = em.find(entityClass, primaryKey);
        Validate.isTrue((entity != null ? 1 : 0) != 0, (String)"Could not find entity %s with primary key %d", (Object[])new Object[]{entityClass.getName(), primaryKey});
        em.remove(entity);
    }

    private JPAUtils() {
    }
}

