/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.html;

import com.anahata.util.lang.Nvl;
import org.apache.commons.lang3.Validate;

public final class TableBuilder {
    private String style;
    private StringBuilder th = new StringBuilder();
    private StringBuilder tr = new StringBuilder();
    boolean processingRow = false;

    public TableBuilder style(String style) {
        Validate.notNull((Object)style);
        this.style = style;
        return this;
    }

    public TableBuilder th(String value) {
        return this.th(null, value);
    }

    public TableBuilder th(String style, String value) {
        this.th.append("<th");
        this.appendStyle(this.th, style);
        this.th.append(">");
        if (value != null) {
            this.th.append(value);
        }
        this.th.append("</th>");
        return this;
    }

    public TableBuilder tr() {
        if (!this.processingRow) {
            this.tr.append("<tr>");
        } else {
            this.tr.append("</tr><tr>");
        }
        this.processingRow = true;
        return this;
    }

    public TableBuilder td(String value) {
        return this.td(null, value, null);
    }

    public TableBuilder td(String style, String value) {
        return this.td(style, value, null);
    }

    public TableBuilder td(String style, String value, Integer colspan) {
        if (!this.processingRow) {
            this.tr();
        }
        this.tr.append("<td");
        if (colspan != null) {
            this.tr.append(" colspan='");
            this.tr.append(colspan);
            this.tr.append("'");
        }
        this.appendStyle(this.tr, style);
        this.tr.append(">");
        if (value != null) {
            this.tr.append(Nvl.nvl(value).replace("\n", "<BR/>"));
        }
        this.tr.append("</td>");
        return this;
    }

    public TableBuilder trTdLabelValue(String labelStyle, String label, String valueStyle, Object value) {
        this.tr();
        this.tdLabelValue(labelStyle, label, valueStyle, value);
        return this;
    }

    public TableBuilder tdLabelValue(String labelStyle, String label, String valueStyle, Object value) {
        if (value == null) {
            return this;
        }
        this.td(labelStyle, label);
        this.td(valueStyle, String.valueOf(value));
        return this;
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table");
        this.appendStyle(sb, this.style);
        sb.append(">");
        if (this.th.length() > 0) {
            sb.append("<thead><tr>");
            sb.append((CharSequence)this.th);
            sb.append("</tr></thead>");
        }
        if (this.tr.length() > 0) {
            sb.append("<tbody>");
            sb.append((CharSequence)this.tr);
            sb.append("</tr></tbody>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    private void appendStyle(StringBuilder sb, String styleValue) {
        if (styleValue != null) {
            sb.append(" style='");
            sb.append(styleValue);
            sb.append("'");
        }
    }
}

