/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.email;

import com.anahata.util.email.ByteArrayAttachment;
import com.anahata.util.plaf.ByteUnit;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Email {
    private String from;
    private String subject;
    private List<String> to = new ArrayList<String>();
    private List<String> cc = new ArrayList<String>();
    private List<String> bcc = new ArrayList<String>();
    private List<ByteArrayAttachment> attachments = new ArrayList<ByteArrayAttachment>();
    private byte[] zippedContent;

    public long getTotalAttachmentsSize() {
        long ret = 0L;
        for (ByteArrayAttachment attachment : this.attachments) {
            ret += (long)attachment.getData().length;
        }
        return ret;
    }

    public void compressAttachments(String name) {
        if (!name.toLowerCase().endsWith(".zip")) {
            name = name + ".zip";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)this.getTotalAttachmentsSize());
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            for (ByteArrayAttachment attachment : this.attachments) {
                zos.putNextEntry(new ZipEntry(attachment.getName()));
                zos.write(attachment.getData());
                zos.closeEntry();
            }
            zos.close();
            this.attachments.clear();
            this.attachments.add(new ByteArrayAttachment(name, baos.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception compressing attachments", e);
        }
    }

    public boolean compressAttachmentsIfLargerThanMb(int mb, String name) {
        double byteSize = ByteUnit.MEGABYTE.to(mb, ByteUnit.BYTE);
        if ((double)this.getTotalAttachmentsSize() > byteSize) {
            this.compressAttachments(name);
            return true;
        }
        return false;
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<String> getTo() {
        return this.to;
    }

    public List<String> getCc() {
        return this.cc;
    }

    public List<String> getBcc() {
        return this.bcc;
    }

    public List<ByteArrayAttachment> getAttachments() {
        return this.attachments;
    }

    public byte[] getZippedContent() {
        return this.zippedContent;
    }

    public String toString() {
        return "Email(from=" + this.getFrom() + ", subject=" + this.getSubject() + ", to=" + this.getTo() + ", cc=" + this.getCc() + ", bcc=" + this.getBcc() + ", attachments=" + this.getAttachments() + ")";
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setZippedContent(byte[] zippedContent) {
        this.zippedContent = zippedContent;
    }
}

