/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.cdi;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.Validate;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Cdi {
    private static final Logger log = LoggerFactory.getLogger(Cdi.class);
    private static final Cdi INSTANCE = new Cdi();
    private boolean se;
    private Object weldContainer = null;
    private Object weld = null;

    private Cdi() {
        try {
            Class.forName("org.jboss.weld.environment.se.Weld");
            this.se = true;
            log.info("Cdi SE env detected, initializing weld");
            this.weld = new Weld();
            long ts = System.currentTimeMillis();
            this.weldContainer = ((Weld)this.weld).initialize();
            ts = System.currentTimeMillis() - ts;
            log.info("Cdi SE initialised in {} ms", (Object)ts);
        }
        catch (ClassNotFoundException e) {
            log.debug("Could not locate Weld SE class, assuming JEE environment {}", (Object)e.toString());
            this.se = false;
        }
    }

    public static boolean isSe() {
        return Cdi.INSTANCE.se;
    }

    public static void fireEvent(Object event, Annotation ... qualifiers) {
        Cdi.getBeanManager().fireEvent(event, qualifiers);
    }

    public static BeanManager getBeanManager() {
        if (Cdi.INSTANCE.se) {
            return ((WeldContainer)Cdi.INSTANCE.weldContainer).getBeanManager();
        }
        return Cdi.lookupBeanManager();
    }

    public static <T> T get(Class<T> clazz, Annotation ... qualifiers) {
        return INSTANCE.getBean(clazz, qualifiers);
    }

    private <T> T getBean(Class<T> clazz, Annotation ... qualifiers) {
        Validate.notNull(clazz);
        if (this.se) {
            return (T)((WeldContainer)this.weldContainer).instance().select(clazz, qualifiers).get();
        }
        BeanManager bm = Cdi.lookupBeanManager();
        Bean bean = (Bean)bm.getBeans(clazz, qualifiers).iterator().next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        Object result = bm.getReference(bean, clazz, ctx);
        return (T)result;
    }

    private static BeanManager lookupBeanManager() {
        try {
            InitialContext ic = new InitialContext();
            return (BeanManager)ic.lookup("java:comp/BeanManager");
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    private class CdiShutdownHook
    extends Thread {
        public CdiShutdownHook() {
            super.setName("CdiShutdownHook");
        }

        @Override
        public void run() {
            Weld weld_ = (Weld)Cdi.this.weld;
            if (weld_ != null) {
                log.debug("Calling weld.shutdown on {}", Cdi.this.weld);
                weld_.shutdown();
                log.debug("Completed weld.shutdown ");
            } else {
                log.warn("Weld SE was null on CDI shutdown hook. Initialization must have failed");
            }
        }
    }
}

