/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery.jandex;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveHandler;
import org.jboss.weld.environment.deployment.discovery.jandex.JandexDiscoveryStrategy;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.util.Preconditions;

public class JandexIndexBeanArchiveHandler
implements BeanArchiveHandler {
    private static final String JANDEX_INDEX_NAME = "META-INF/jandex.idx";
    private static final String JAR_URL_PREFIX = "jar:";
    private static final String FILE_URL_PREFIX = "file:";
    private static final String JAR_SEPARATOR = "!/";
    private static final String FILE_SEPARATOR = "/";
    private Index indexCache = null;
    private String indexCacheUrlPath = null;

    public boolean canHandle(String urlPath) {
        return this.getIndex(urlPath) != null;
    }

    public BeanArchiveBuilder handle(String urlPath) {
        Index index = this.getIndex(urlPath);
        if (index == null) {
            return null;
        }
        BeanArchiveBuilder builder = new BeanArchiveBuilder().setAttribute(JandexDiscoveryStrategy.INDEX_ATTRIBUTE_NAME, (Object)index);
        this.handleArchiveByIndex(index, builder);
        return builder;
    }

    private Index getIndex(String urlPath) {
        System.out.println("Getting index for path " + urlPath);
        Preconditions.checkArgumentNotNull((Object)urlPath, (String)"urlPath");
        if (this.indexCacheUrlPath == null || !this.indexCacheUrlPath.equals(urlPath)) {
            Index newIndex;
            this.indexCache = newIndex = this.loadJandexIndex(urlPath);
            this.indexCacheUrlPath = urlPath;
        }
        return this.indexCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index loadJandexIndex(String urlPath) {
        URL indexURL = null;
        Index index = null;
        String indexUrlString = this.getJandexIndexURLString(urlPath);
        System.out.println("indexUrlString =" + indexUrlString);
        try {
            indexURL = new URL(indexUrlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
        InputStream indexFileStream = null;
        try {
            indexFileStream = indexURL.openStream();
            CommonLogger.LOG.foundJandexIndex(indexURL);
            IndexReader indexFileReader = new IndexReader(indexFileStream);
            index = indexFileReader.read();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            CommonLogger.LOG.warnv("Jandex index at {} is not valid", (Object)indexUrlString);
        }
        catch (FileNotFoundException ignore) {
            ignore.printStackTrace();
            CommonLogger.LOG.tracev("No Jandex index found at {}", (Object)indexUrlString);
        }
        catch (IOException ioe) {
            CommonLogger.LOG.warnv("Cannot load Jandex index at {}", (Object)indexUrlString);
            CommonLogger.LOG.catchingDebug((Throwable)ioe);
        }
        finally {
            if (indexFileStream != null) {
                try {
                    indexFileStream.close();
                }
                catch (IOException ioe) {
                    CommonLogger.LOG.couldNotCloseStreamOfJandexIndex((Object)urlPath, (Throwable)ioe);
                }
            }
        }
        return index;
    }

    private String getJandexIndexURLString(String urlPath) {
        String separator;
        String prefix;
        File f;
        boolean isJar = urlPath.toLowerCase().endsWith(".jar");
        if (!isJar && (f = new File(urlPath)).exists() && !f.isDirectory()) {
            System.out.println("Assuming " + urlPath + " as jar");
            isJar = true;
        }
        if (isJar) {
            prefix = "jar:file:";
            separator = JAR_SEPARATOR;
        } else {
            prefix = FILE_URL_PREFIX;
            separator = FILE_SEPARATOR;
        }
        return prefix + urlPath + separator + JANDEX_INDEX_NAME;
    }

    private void handleArchiveByIndex(Index index, BeanArchiveBuilder builder) {
        for (ClassInfo classInfo : index.getKnownClasses()) {
            builder.addClass(classInfo.name().toString());
        }
    }
}

