/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.search;

import com.anahata.yam.model.search.TokenType;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;

public class SearchToken
implements Serializable {
    private String token;
    private int weight;
    private TokenType type;
    private List<SearchToken> subTokens;

    SearchToken(String token, int weight, TokenType type) {
        Validate.notNull((Object)weight, (String)token, (Object[])new Object[]{"token can not be null"});
        Validate.isTrue((!token.trim().isEmpty() ? 1 : 0) != 0, (String)"token can not be empty", (Object[])new Object[0]);
        Validate.isTrue((weight > 0 ? 1 : 0) != 0, (String)("weight should be > 0 for token '" + token + "'"), (Object[])new Object[0]);
        Validate.notNull((Object)((Object)type), (String)"type is required", (Object[])new Object[0]);
        Validate.isTrue((type == TokenType.BASIC || type == TokenType.QUOTED ? 1 : 0) != 0, (String)"This constructor only allows BASIC and QUOTED token types", (Object[])new Object[0]);
        this.token = token.trim().toLowerCase();
        this.weight = weight;
        this.type = type;
    }

    SearchToken(List<SearchToken> subTokens) {
        Validate.notNull(subTokens, (String)"subTokenscan not be null", (Object[])new Object[0]);
        Validate.isTrue((subTokens.size() >= 2 ? 1 : 0) != 0, (String)"subtokens must contain at least two toknes", (Object[])new Object[0]);
        StringBuilder sb = new StringBuilder();
        for (SearchToken st : subTokens) {
            Validate.isTrue((st.type != TokenType.COMPOSITE ? 1 : 0) != 0, (String)"A composite token can only be formed by non composite toknes", (Object[])new Object[0]);
            sb.append(st.getToken());
            sb.append(" ");
            this.weight += st.getWeight();
        }
        this.token = sb.toString().trim();
        this.subTokens = Collections.unmodifiableList(subTokens);
        this.type = TokenType.COMPOSITE;
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.token);
        hash = 61 * hash + this.weight;
        hash = 61 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 61 * hash + Objects.hashCode(this.subTokens);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchToken other = (SearchToken)obj;
        if (!Objects.equals(this.token, other.token)) {
            return false;
        }
        if (this.weight != other.weight) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.type != TokenType.COMPOSITE || CollectionUtils.isEqualCollection(this.subTokens, other.subTokens);
    }

    public String getToken() {
        return this.token;
    }

    public int getWeight() {
        return this.weight;
    }

    public TokenType getType() {
        return this.type;
    }

    public List<SearchToken> getSubTokens() {
        return this.subTokens;
    }

    public String toString() {
        return "SearchToken(token=" + this.getToken() + ", weight=" + this.getWeight() + ", type=" + (Object)((Object)this.getType()) + ", subTokens=" + this.getSubTokens() + ")";
    }
}

