/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.validator.constraints;

import com.anahata.util.validator.constraints.FieldMatch;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.beanutils.PropertyUtils;

public class FieldMatchValidator
implements ConstraintValidator<FieldMatch, Object> {
    private String firstFieldName;
    private String secondFieldName;

    public void initialize(FieldMatch constraintAnnotation) {
        this.firstFieldName = constraintAnnotation.first();
        this.secondFieldName = constraintAnnotation.second();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        try {
            Object firstObj = PropertyUtils.getProperty((Object)value, (String)this.firstFieldName);
            Object secondObj = PropertyUtils.getProperty((Object)value, (String)this.secondFieldName);
            boolean valid = Objects.equals(firstObj, secondObj);
            if (!valid) {
                context.disableDefaultConstraintViolation();
                if (secondObj != null) {
                    context.buildConstraintViolationWithTemplate("Value doesn't match").addPropertyNode("#" + this.firstFieldName).addConstraintViolation();
                }
                context.buildConstraintViolationWithTemplate("Value doesn't match").addPropertyNode("#" + this.secondFieldName).addConstraintViolation();
                return false;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return true;
    }
}

