/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.validator.constraints;

import com.anahata.util.model.Activatable;
import com.anahata.util.validator.constraints.ActiveSize;
import java.util.Collection;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;

public class ActiveSizeValidator
implements ConstraintValidator<ActiveSize, Collection<? extends Activatable>> {
    private ActiveSize constraint;

    public void initialize(ActiveSize constraintAnnotation) {
        this.constraint = constraintAnnotation;
    }

    public boolean isValid(Collection<? extends Activatable> value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        int size = 0;
        for (Activatable activatable : value) {
            if (!activatable.isActive()) continue;
            ++size;
        }
        if (size >= this.constraint.min() && size <= this.constraint.max()) {
            return true;
        }
        if (!StringUtils.isBlank((CharSequence)this.constraint.field())) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.constraint.message()).addPropertyNode("#" + this.constraint.field()).addConstraintViolation();
        }
        return false;
    }
}

