/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.transport.rpc.client.impl;

import com.anahata.util.transport.rpc.Rpc;
import com.anahata.util.transport.rpc.RpcException;
import com.anahata.util.transport.rpc.RpcStreamer;
import com.anahata.util.transport.rpc.client.RpcClientTransport;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JavaSeRpcClientTransport
implements RpcClientTransport {
    private static final Logger log = LoggerFactory.getLogger(JavaSeRpcClientTransport.class);

    @Override
    public Object sendReceive(RpcStreamer streamer, URL url, Rpc rpc) throws Exception {
        log.trace("Preparing post of {}", (Object)rpc);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
        }
        catch (ConnectException e) {
            throw new RpcException("Exception connecting to " + url, e);
        }
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Content-Type", "application/octet-stream");
        connection.addRequestProperty("AnahataCompression", streamer.getCompressionType().name());
        connection.addRequestProperty("AnahataSerialization", streamer.getSerializationType().name());
        connection.setAllowUserInteraction(true);
        try {
            connection.connect();
        }
        catch (IOException e) {
            throw new RpcException("Exception connecting to " + url, e);
        }
        try (DataOutputStream dstream = new DataOutputStream(connection.getOutputStream());){
            streamer.stream((Object)rpc, dstream);
        }
        connection.getOutputStream().flush();
        log.trace("Connected to {} POSTed {} bytes", (Object)url, (Object)rpc);
        Object ret = streamer.receive(connection.getInputStream());
        connection.disconnect();
        return ret;
    }
}

