/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.transport.rpc;

import com.anahata.util.formatting.FormattingUtils;
import com.anahata.util.io.CompressionType;
import com.anahata.util.io.SerializationType;
import com.anahata.util.transport.rpc.RpcStreamer;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RpcStreamerBenchmark {
    private static final Logger log = LoggerFactory.getLogger(RpcStreamerBenchmark.class);
    private RpcStreamer streamer;
    long fastest = Long.MAX_VALUE;
    private String fastestDesc = "";
    private long smallest = Long.MAX_VALUE;
    private String smallestDesc = "";
    private Object test;
    private long smallestTime;
    private long fastestSize;

    public RpcStreamerBenchmark(RpcStreamer streamer, Object test) {
        this.streamer = streamer;
        this.test = test;
    }

    public void run() {
        ArrayList<Result> results = new ArrayList<Result>();
        this.fastest = Long.MAX_VALUE;
        this.fastestDesc = "";
        this.smallest = Long.MAX_VALUE;
        this.smallestDesc = "";
        for (SerializationType st : SerializationType.values()) {
            for (CompressionType ct : CompressionType.values()) {
                this.streamer.setSerializationType(st);
                this.streamer.setCompressionType(ct);
                try {
                    long singleTs = System.currentTimeMillis();
                    byte[] b = this.streamer.stream(this.test);
                    this.streamer.uncompressDeserialize(b);
                    singleTs = System.currentTimeMillis() - singleTs;
                    results.add(new Result(this.streamer.toString(), singleTs, b.length));
                    if ((long)b.length < this.smallest) {
                        this.smallest = b.length;
                        this.smallestDesc = this.streamer.toString();
                        this.smallestTime = singleTs;
                    }
                    if (singleTs >= this.fastest) continue;
                    this.fastest = singleTs;
                    this.fastestDesc = this.streamer.toString();
                    this.fastestSize = b.length;
                }
                catch (Exception e) {
                    System.out.println("Could not ser/unser: " + this.streamer);
                    e.printStackTrace();
                }
            }
        }
        Collections.sort(results);
        String s = FormattingUtils.collectionToTableString(results);
        log.debug("\n" + s);
    }

    public String toString() {
        return "RpcStreamerBenchmark{fastest=" + this.fastest + ", fastestDesc=" + this.fastestDesc + ", smallest=" + this.smallest + ", smallestDesc=" + this.smallestDesc + ", smallestTime=" + this.smallestTime + ", fastestSize=" + this.fastestSize + '}';
    }

    @ConstructorProperties(value={"streamer", "fastest", "fastestDesc", "smallest", "smallestDesc", "test", "smallestTime", "fastestSize"})
    public RpcStreamerBenchmark(RpcStreamer streamer, long fastest, String fastestDesc, long smallest, String smallestDesc, Object test, long smallestTime, long fastestSize) {
        this.streamer = streamer;
        this.fastest = fastest;
        this.fastestDesc = fastestDesc;
        this.smallest = smallest;
        this.smallestDesc = smallestDesc;
        this.test = test;
        this.smallestTime = smallestTime;
        this.fastestSize = fastestSize;
    }

    private RpcStreamerBenchmark() {
    }

    private static class Result
    implements Comparable<Result> {
        String name;
        long time;
        int size;

        @Override
        public int compareTo(Result o) {
            return o.size - this.size;
        }

        public String toString() {
            return "Result{name=" + this.name + ", time=" + this.time + ", size=" + this.size + '}';
        }

        @ConstructorProperties(value={"name", "time", "size"})
        public Result(String name, long time, int size) {
            this.name = name;
            this.time = time;
            this.size = size;
        }
    }
}

