/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.transport.rpc;

import com.anahata.util.transport.rpc.NonDeserializableException;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RcpError
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RcpError.class);
    private byte[] exception;
    private String exceptionString;

    public RcpError(Throwable t) {
        try {
            this.exception = SerializationUtils.serialize((Serializable)t);
        }
        catch (Exception e) {
            log.debug("Non serializable exception", (Throwable)e);
        }
        this.exceptionString = ExceptionUtils.getStackTrace((Throwable)t);
    }

    public Throwable getException() {
        try {
            return (Throwable)SerializationUtils.deserialize((byte[])this.exception);
        }
        catch (Exception e) {
            return new NonDeserializableException(this.exceptionString);
        }
    }

    public void doThrow() throws Throwable {
        Throwable t = this.getException();
        log.debug("RpcError throwing {}", (Object)t.toString());
        throw t;
    }

    public String toString() {
        return "RcpError{exception=" + this.exception + ", exceptionString=" + this.exceptionString + '}';
    }

    public RcpError() {
    }
}

