/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.sysparam;

import com.anahata.util.sysparam.EJBDataSource;
import com.anahata.util.sysparam.SystemParameterDataSource;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemParameter {
    private static final Logger log = LoggerFactory.getLogger(SystemParameter.class);
    public static final String SYSPARAM_IMPL_CLASS_NAME = "com.anahata.util.sysparam.classname";
    public static final String PARAM_EXPIRY = "sysparam.expiry";
    private static final long DEFAULT_EXPIRY = 0L;
    private static SystemParameterDataSource dataSource;
    private static Properties props;
    private static long lastRefresh;
    private static long expiry;

    private static synchronized void init() {
        String dsClassName = System.getProperty(SYSPARAM_IMPL_CLASS_NAME);
        if (dsClassName == null) {
            log.trace("init: No property for the class name, defaulting to EJBDataSource");
            dataSource = new EJBDataSource();
        } else {
            log.trace("init: Instantiating class {}", (Object)dsClassName);
            try {
                Class<?> c = Class.forName(dsClassName);
                dataSource = (SystemParameterDataSource)c.newInstance();
            }
            catch (Exception e) {
                log.error("init: Could not instantiate class {}", (Object)dsClassName, (Object)e);
                throw new RuntimeException(e);
            }
        }
        props = dataSource.load();
        expiry = SystemParameter.getExpiry();
        log.info("init: System parameters expiry time set to {} seconds", (Object)expiry);
        lastRefresh = System.currentTimeMillis();
    }

    private SystemParameter() {
    }

    public static String getString(String key) {
        return SystemParameter.getProperties().getProperty(key);
    }

    public static String getString(String key, String defaultValue) {
        return SystemParameter.getProperties().getProperty(key, defaultValue);
    }

    public static Boolean getBoolean(String key) {
        String value = SystemParameter.getProperties().getProperty(key);
        return value == null ? null : Boolean.valueOf(value);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        String value = SystemParameter.getProperties().getProperty(key);
        return value == null ? defaultValue : Boolean.valueOf(value);
    }

    private static synchronized Properties getProperties() {
        if (dataSource == null) {
            SystemParameter.init();
        }
        if (expiry != 0L && System.currentTimeMillis() - lastRefresh > expiry * 1000L) {
            props = dataSource.load();
            expiry = SystemParameter.getExpiry();
            log.info("getProperties: System properties reloaded, expiry time set to {} seconds", (Object)expiry);
            lastRefresh = System.currentTimeMillis();
        }
        return props;
    }

    private static long getExpiry() {
        return Long.valueOf(props.getProperty(PARAM_EXPIRY, String.valueOf(0L)));
    }

    static {
        lastRefresh = 0L;
        expiry = 0L;
    }
}

