/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.search;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public final class AnahataSearchUtils {
    public static boolean contains(Object source, String[] tokens) {
        if (source == null || tokens == null || tokens.length == 0) {
            return false;
        }
        String sourceString = String.valueOf(source);
        for (String token : tokens) {
            Validate.notNull((Object)token, (String)"Tokens contains null element", (Object[])new Object[0]);
            Pattern pattern = AnahataSearchUtils.makeTokenMatchPattern(token.toLowerCase());
            Matcher m = pattern.matcher(sourceString);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public static Pattern makeTokenMatchPattern(String token) {
        StringBuilder sb = new StringBuilder();
        char[] carray = token.toCharArray();
        for (int i = 0; i < carray.length; ++i) {
            sb.append("\\s*?");
            sb.append(Pattern.quote(")")).append("*?");
            sb.append("\\s*?");
            sb.append(Pattern.quote("(")).append("*?");
            sb.append(Pattern.quote(String.valueOf(carray[i])));
        }
        sb.append("\\s*?");
        sb.append(Pattern.quote(")")).append("*?");
        sb.append("\\s*?");
        sb.append(Pattern.quote("(")).append("*?");
        Pattern pattern = Pattern.compile(sb.toString(), 2);
        return pattern;
    }

    public static List<String> tokenize(String queryString) {
        ArrayList<String> matchList = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher regexMatcher = regex.matcher(queryString);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(regexMatcher.group(2));
                continue;
            }
            matchList.add(regexMatcher.group());
        }
        return matchList;
    }
}

