/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.plaf;

import com.anahata.util.plaf.win.WinRegistry;
import java.io.File;

public final class OSUtils {
    private static final String SYSPROP_OS_NAME = "os.name";
    private static final String SYSPROP_OS_USER_NAME = "user.name";
    private static final String SYSPROP_OS_USER_HOME = "user.home";
    private static final String OS_NAME_UNKNOWN = "unknown";
    private static final String OS_NAME_MAC_1 = "mac";
    private static final String OS_NAME_MAC_2 = "darwin";
    private static final String OS_NAME_WINDOWS = "windows";
    private static final String OS_NAME_LINUX = "linux";
    private static final String OS_NAME_SUNOS = "sunos";

    public static boolean isWindows() {
        String osName = OSUtils.getOsName();
        return osName.startsWith(OS_NAME_WINDOWS);
    }

    public static boolean isMac() {
        String osName = OSUtils.getOsName();
        return osName.startsWith(OS_NAME_MAC_1) || osName.startsWith(OS_NAME_MAC_2);
    }

    public static boolean isLinux() {
        String osName = OSUtils.getOsName();
        return osName.startsWith(OS_NAME_LINUX);
    }

    public static boolean isSunOS() {
        String osName = OSUtils.getOsName();
        return osName.startsWith(OS_NAME_SUNOS);
    }

    private static String getOsName() {
        return System.getProperty(SYSPROP_OS_NAME, OS_NAME_UNKNOWN).toLowerCase();
    }

    public static File findExecutableOnPath(String windowsName, String macName, String linuxName) {
        if (OSUtils.isWindows()) {
            return OSUtils.findExecutableOnPath(windowsName);
        }
        if (OSUtils.isMac()) {
            return OSUtils.findExecutableOnPath(macName);
        }
        if (OSUtils.isLinux() || OSUtils.isSunOS()) {
            return OSUtils.findExecutableOnPath(linuxName);
        }
        throw new IllegalStateException("Unknown OS");
    }

    public static File findExecutableOnPath(String executableName) {
        String location;
        String systemPath = System.getenv("PATH");
        String[] pathDirs = systemPath.split(File.pathSeparator);
        File fullyQualifiedExecutable = null;
        for (String pathDir : pathDirs) {
            File file = new File(pathDir, executableName);
            if (!file.isFile()) continue;
            fullyQualifiedExecutable = file;
            break;
        }
        if (fullyQualifiedExecutable == null && OSUtils.isWindows() && (location = WinRegistry.findAppLocation(executableName)) != null) {
            fullyQualifiedExecutable = new File(WinRegistry.findAppLocation(executableName));
        }
        return fullyQualifiedExecutable;
    }

    public static String getUserName() {
        return System.getProperties().getProperty(SYSPROP_OS_USER_NAME);
    }

    public static String getUserHome() {
        return System.getProperties().getProperty(SYSPROP_OS_USER_HOME);
    }

    private OSUtils() {
    }
}

