/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.AppenderBase;
import com.anahata.util.cdi.Cdi;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorEventAppender
extends AppenderBase<ILoggingEvent> {
    private static final Logger log = LoggerFactory.getLogger(ErrorEventAppender.class);
    private static ErrorEventAppender instance;
    private int bufferSize = 300;
    private long errorTimeout = 300L;
    private String ignoreErrors;
    private String ignoreThreads;
    private String ignoreLoggers;
    private List<String> ignoreErrorsList = new ArrayList<String>();
    private List<String> ignoreThreadsList = new ArrayList<String>();
    private List<String> ignoreLoggersList = new ArrayList<String>();
    private Deque<ILoggingEvent> logBuffer = new ConcurrentLinkedDeque<ILoggingEvent>();
    private long lastLogTs;
    private State state = State.SEARCHING;
    @Inject
    private Event<ErrorEventAppender> eventMonitor;

    public ErrorEventAppender() {
        instance = this;
    }

    public static ErrorEventAppender getInstance() {
        return instance;
    }

    protected void append(ILoggingEvent e) {
        this.lastLogTs = e.getTimeStamp();
        boolean errorOrHigher = e.getLevel().isGreaterOrEqual(Level.ERROR);
        this.logBuffer.addLast(e);
        if (this.logBuffer.size() > this.bufferSize) {
            this.logBuffer.removeFirst();
        }
        if (this.state == State.SEARCHING && errorOrHigher && !this.shouldIgnore(e)) {
            this.state = State.FOUND;
            try {
                Cdi.fireEvent((Object)this, new Annotation[0]);
            }
            catch (Exception ex) {
                log.warn("Could not find error event", (Throwable)ex);
            }
        }
        if (this.state == State.FOUND && !errorOrHigher) {
            this.state = State.SEARCHING;
        }
    }

    private boolean shouldIgnore(ILoggingEvent e) {
        if (!this.ignoreErrorsList.isEmpty()) {
            if (ErrorEventAppender.matches(this.ignoreErrorsList, e.getMessage())) {
                log.debug("message : '" + e.getMessage() + "' matches ignoreErrorsList");
                return true;
            }
            if (ErrorEventAppender.matches(this.ignoreErrorsList, e.getFormattedMessage())) {
                log.debug("Formatted message : '" + e.getFormattedMessage() + "' matches ignoreErrorsList");
                return true;
            }
            for (IThrowableProxy itp = e.getThrowableProxy(); itp != null; itp = itp.getCause()) {
                String nameWithMessage = itp.getClassName() + ": " + itp.getMessage();
                if (ErrorEventAppender.matches(this.ignoreErrorsList, nameWithMessage)) {
                    log.debug("IThrowableProxy nameWithMessage : '" + nameWithMessage + "' matches ignoreErrorsList ");
                    return true;
                }
                if (ErrorEventAppender.matches(this.ignoreErrorsList, itp.getClassName())) {
                    log.debug("IThrowableProxy class name: '" + itp.getClassName() + "' matches ignoreErrorsList ");
                    return true;
                }
                if (ErrorEventAppender.matches(this.ignoreErrorsList, itp.getMessage())) {
                    log.debug("IThrowableProxy message: '" + itp.getMessage() + "' matches ignoreErrorsList");
                    return true;
                }
                for (StackTraceElementProxy ste : itp.getStackTraceElementProxyArray()) {
                    if (!ErrorEventAppender.matches(this.ignoreErrorsList, ste.toString())) continue;
                    log.debug("StackTraceElementProxy ste.toString {}, matches ignoreErrorsList", (Object)ste.toString());
                    return true;
                }
            }
        }
        if (ErrorEventAppender.matches(this.ignoreThreadsList, e.getThreadName())) {
            log.debug("Ignoreing thread: " + e.getThreadName());
            return true;
        }
        if (ErrorEventAppender.matches(this.ignoreLoggersList, e.getLoggerName())) {
            log.debug("Ignoring Logger: " + e.getLoggerName());
            return true;
        }
        return false;
    }

    public synchronized List<ILoggingEvent> getLoggingEvents() {
        return new ArrayList<ILoggingEvent>(this.logBuffer);
    }

    public void setIgnoreErrors(String ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
        this.ignoreErrorsList = ErrorEventAppender.toList(ignoreErrors);
    }

    public void setIgnoreThreads(String ignoreThreads) {
        this.ignoreThreads = ignoreThreads;
        this.ignoreThreadsList = ErrorEventAppender.toList(ignoreThreads);
    }

    public void setIgnoreLoggers(String ignoreLoggers) {
        this.ignoreLoggers = ignoreLoggers;
        this.ignoreLoggersList = ErrorEventAppender.toList(ignoreLoggers);
    }

    private static boolean matches(List<String> patterns, String error) {
        if (error == null) {
            return false;
        }
        for (String pattern : patterns) {
            log.trace("Comparing error {} with pattern {}, matches={}", (Object)error, (Object)pattern);
            boolean match = error.toLowerCase().contains(pattern.toLowerCase());
            if (log.isTraceEnabled()) {
                log.trace("error {} with pattern {}, matches={}", new Object[]{error.toLowerCase(), pattern.toLowerCase(), match});
            }
            if (!match) continue;
            log.debug("{} matches {}", (Object)error, (Object)pattern);
            return true;
        }
        return false;
    }

    private static List<String> toList(String ignoreErrors) {
        ArrayList<String> ret = new ArrayList<String>();
        if (ignoreErrors != null) {
            String[] lines;
            for (String string : lines = ignoreErrors.split("\n")) {
                if ((string = string.trim()).isEmpty()) continue;
                ret.add(string);
            }
        }
        return ret;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public long getErrorTimeout() {
        return this.errorTimeout;
    }

    public void setErrorTimeout(long errorTimeout) {
        this.errorTimeout = errorTimeout;
    }

    public String getIgnoreErrors() {
        return this.ignoreErrors;
    }

    public String getIgnoreThreads() {
        return this.ignoreThreads;
    }

    public String getIgnoreLoggers() {
        return this.ignoreLoggers;
    }

    Deque<ILoggingEvent> getLogBuffer() {
        return this.logBuffer;
    }

    long getLastLogTs() {
        return this.lastLogTs;
    }

    State getState() {
        return this.state;
    }

    void setState(State state) {
        this.state = state;
    }

    static enum State {
        SEARCHING,
        FOUND;

    }
}

