/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging;

import com.anahata.util.logging.RemoteServiceWarning;
import com.anahata.util.transport.rpc.RpcStreamer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class RemoteServiceLogger
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RemoteServiceLogger.class);
    private static long DEFAULT_MAX_RET_SIZE = 65536L;
    private static long DEFAULT_MAX_ARGS_SIZE = 32768L;
    private static long DEFAULT_MAX_TIME = 3000L;
    @Inject
    private Event<RemoteServiceWarning> event;
    private Object remoteProxy;
    @Inject
    private RpcStreamer streamer;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RemoteServiceWarning warn;
        long maxArgsSize = this.getMaxArgsSize(method);
        long maxRetSize = this.getMaxRetSize(method);
        long maxTime = this.getMaxTime(method);
        long compressTs = System.currentTimeMillis();
        long argsSize = this.streamer.getCompressedSize(args);
        compressTs = System.currentTimeMillis() - compressTs;
        if (argsSize > maxArgsSize) {
            RemoteServiceWarning warn2 = RemoteServiceWarning.newArgsLarge(method, args, argsSize);
            log.debug("firing " + warn2);
            try {
                this.event.fire((Object)warn2);
            }
            catch (Exception e) {
                log.warn("Exception firing argsSize warning event", (Throwable)e);
            }
        }
        long time = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("Invoking @RemoteService {} {}.{} with {} bytes of args data", new Object[]{method.getReturnType(), method.getDeclaringClass().getSimpleName(), method.getName(), argsSize});
        }
        Object ret = null;
        try {
            ret = method.invoke(this.remoteProxy, args);
        }
        catch (Throwable e) {
            while (e instanceof InvocationTargetException && e.getCause() != null) {
                e = e.getCause();
            }
            log.debug("unwrapped exception: {}", e);
            throw e;
        }
        time = System.currentTimeMillis() - time;
        long retSize = this.streamer.getCompressedSize(ret);
        if (time > maxTime) {
            warn = RemoteServiceWarning.newSlow(method, args, argsSize, ret, retSize, time);
            log.debug("firing " + warn);
            try {
                this.event.fire((Object)warn);
            }
            catch (Exception e) {
                log.warn("Exception firing maxTime warning event", (Throwable)e);
            }
        }
        if (retSize > maxRetSize) {
            warn = RemoteServiceWarning.newRetLarge(method, ret, retSize);
            log.debug("firing " + warn);
            try {
                this.event.fire((Object)warn);
            }
            catch (Exception e) {
                log.warn("Exception firing retSize warning event", (Throwable)e);
            }
        }
        log.debug("@RemoteService {}.{} received data = {} bytes. took {} ms ", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), retSize, time});
        return ret;
    }

    private long getMaxArgsSize(Method method) {
        return DEFAULT_MAX_ARGS_SIZE;
    }

    private long getMaxRetSize(Method method) {
        return DEFAULT_MAX_RET_SIZE;
    }

    private long getMaxTime(Method method) {
        return DEFAULT_MAX_TIME;
    }

    public void setRemoteProxy(Object remoteProxy) {
        this.remoteProxy = remoteProxy;
    }
}

