/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class JULUtils {
    private static final int STACK_ELEMENTS_TO_CALLER = 3;

    public static Logger getLogger() {
        return Logger.getLogger(JULUtils.getCallingClassName());
    }

    public static void exception(String msg, Throwable t) {
        Logger.getLogger(JULUtils.getCallingClassName()).log(Level.SEVERE, msg, t);
    }

    public static void exiting() {
        Logger.getLogger(JULUtils.getCallingClassName()).exiting(JULUtils.getCallingClassName(), JULUtils.getCallingMethod());
    }

    public static void exiting(Object result) {
        Logger.getLogger(JULUtils.getCallingClassName()).exiting(JULUtils.getCallingClassName(), JULUtils.getCallingMethod(), result);
    }

    public static void entering() {
        Logger.getLogger(JULUtils.getCallingClassName()).entering(JULUtils.getCallingClassName(), JULUtils.getCallingMethod());
    }

    public static void entering(Object ... params) {
        Logger.getLogger(JULUtils.getCallingClassName()).entering(JULUtils.getCallingClassName(), JULUtils.getCallingMethod(), params);
    }

    private static String getCallingClassName() {
        return JULUtils.getCallingStackTraceElement().getClassName();
    }

    private static String getCallingMethod() {
        return JULUtils.getCallingStackTraceElement().getMethodName();
    }

    private static StackTraceElement getCallingStackTraceElement() {
        Exception e = new Exception();
        StackTraceElement[] ste = e.getStackTrace();
        StackTraceElement caller = ste[3];
        return caller;
    }

    private JULUtils() {
    }
}

