/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jpa.eclipselink;

import com.anahata.util.jpa.JPAPropertyUtils;
import com.anahata.util.jpa.JpaPropertyDescriptor;
import java.util.HashMap;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.sessions.CopyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CopyGroupUtils {
    private static final Logger log = LoggerFactory.getLogger(CopyGroupUtils.class);

    public static void addAllNonAssociationAttributes(CopyGroup cg, Class ... classes) {
        Validate.notNull((Object)cg);
        Validate.notNull((Object)classes);
        Validate.isTrue((classes.length > 0 ? 1 : 0) != 0, (String)"At least one class must be provided", (Object[])new Object[0]);
        HashMap<String, JpaPropertyDescriptor> props = new HashMap<String, JpaPropertyDescriptor>();
        for (Class c : classes) {
            props.putAll(JPAPropertyUtils.describe(c));
        }
        for (JpaPropertyDescriptor desc : props.values()) {
            if (desc.isRelationship()) continue;
            cg.addAttribute(desc.getPropertyName());
        }
    }

    private CopyGroupUtils() {
    }
}

