/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public final class ImageThumbnail {
    public static byte[] createThumbnail(byte[] inFile, int largestDimension) throws IOException {
        int originalImageLargestDim;
        int sizeDifference;
        double scale;
        Image inImage = ImageIO.read(new ByteArrayInputStream(inFile));
        if (((Image)inImage).getWidth(null) == -1 || ((Image)inImage).getHeight(null) == -1) {
            throw new IllegalArgumentException("In file can not be read");
        }
        if (((Image)inImage).getWidth(null) > ((Image)inImage).getHeight(null)) {
            scale = (double)largestDimension / (double)((Image)inImage).getWidth(null);
            sizeDifference = ((Image)inImage).getWidth(null) - largestDimension;
            originalImageLargestDim = ((Image)inImage).getWidth(null);
        } else {
            scale = (double)largestDimension / (double)((Image)inImage).getHeight(null);
            sizeDifference = ((Image)inImage).getHeight(null) - largestDimension;
            originalImageLargestDim = ((Image)inImage).getHeight(null);
        }
        BufferedImage outImage = new BufferedImage(100, 100, 1);
        if (scale < 1.0) {
            int numSteps = sizeDifference / 100;
            int stepSize = sizeDifference / numSteps;
            int stepWeight = stepSize / 2;
            int heavierStepSize = stepSize + stepWeight;
            int lighterStepSize = stepSize - stepWeight;
            double scaledW = ((Image)inImage).getWidth(null);
            double scaledH = ((Image)inImage).getHeight(null);
            int centerStep = numSteps % 2 == 1 ? (int)Math.ceil((double)numSteps / 2.0) : -1;
            Integer intermediateSize = originalImageLargestDim;
            Integer previousIntermediateSize = originalImageLargestDim;
            Integer i = 0;
            while (i < numSteps) {
                int currentStepSize = i + 1 != centerStep ? (i == numSteps - 1 ? previousIntermediateSize - largestDimension : (numSteps - i > numSteps / 2 ? heavierStepSize : lighterStepSize)) : stepSize;
                intermediateSize = previousIntermediateSize - currentStepSize;
                scale = (double)intermediateSize.intValue() / (double)previousIntermediateSize.intValue();
                scaledW = (double)((int)scaledW) * scale;
                scaledH = (double)((int)scaledH) * scale;
                outImage = new BufferedImage((int)scaledW, (int)scaledH, 1);
                Graphics2D g2d = outImage.createGraphics();
                g2d.setBackground(Color.WHITE);
                g2d.clearRect(0, 0, outImage.getWidth(), outImage.getHeight());
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                AffineTransform tx = new AffineTransform();
                tx.scale(scale, scale);
                g2d.drawImage(inImage, tx, null);
                g2d.dispose();
                inImage = new ImageIcon(outImage).getImage();
                previousIntermediateSize = intermediateSize;
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        } else {
            outImage = new BufferedImage(((Image)inImage).getWidth(null), ((Image)inImage).getHeight(null), 1);
            Graphics2D g2d = outImage.createGraphics();
            g2d.setBackground(Color.WHITE);
            g2d.clearRect(0, 0, outImage.getWidth(), outImage.getHeight());
            AffineTransform tx = new AffineTransform();
            tx.setToIdentity();
            g2d.drawImage(inImage, tx, null);
            g2d.dispose();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.close();
        return os.toByteArray();
    }

    private ImageThumbnail() {
    }
}

