/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.formatting;

import com.anahata.util.formatting.Displayable;
import com.anahata.util.lang.AnahataWordUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public final class FormattingUtils {
    private static final int COLLECTION_AS_TABLE_MIN_COLUMN_WIDTH = 6;
    private static final int COLLECTION_AS_TABLE_DEFAULT_MAX_COLUMN_WIDTH = 90;

    public static String displayablesToString(Collection<? extends Displayable> displayables) {
        if (displayables == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Displayable displayable : displayables) {
            if (displayable == null || StringUtils.isEmpty((CharSequence)displayable.getDisplayValue())) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(displayable.getDisplayValue().trim());
        }
        return sb.toString();
    }

    public static String toStringSkipNulls(String ... tokens) {
        StringBuilder sb = new StringBuilder();
        for (String s : tokens) {
            if (s == null) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String collectionToTableString(Collection<?> collection) {
        return FormattingUtils.collectionToTableString(collection, null, 90);
    }

    public static String collectionToTableString(Collection<?> collection, int maxColWidth) {
        return FormattingUtils.collectionToTableString(collection, null, maxColWidth);
    }

    public static String collectionToTableString(Collection<?> collection, Class<?> type, int maxColWidth) {
        Object fieldValue;
        if (collection == null) {
            return "<null>";
        }
        if (type == null) {
            type = FormattingUtils.getFirstObjectType(collection);
        }
        if (type == null) {
            return "<none>";
        }
        HashMap<String, Integer> columnWidths = new HashMap<String, Integer>();
        AccessibleObject[] fields = type.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            String fieldName = ((Field)field).getName();
            for (Object o : collection) {
                try {
                    Integer maxSoFar;
                    fieldValue = ((Field)field).get(o);
                    int length = String.valueOf(fieldValue).length();
                    if (maxColWidth != -1) {
                        length = Math.min(length, maxColWidth);
                        String displayName = AnahataWordUtils.humaniseCamelCase(fieldName);
                        length = Math.max(length, displayName.length());
                        length = Math.max(length, 6);
                    }
                    if ((maxSoFar = (Integer)columnWidths.get(fieldName)) != null && length <= maxSoFar) continue;
                    columnWidths.put(fieldName, length);
                }
                catch (IllegalAccessException ex) {
                    throw new InternalError("Unexpected IllegalAccessException: " + ex.getMessage());
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("|");
        for (AccessibleObject field : fields) {
            String displayName = AnahataWordUtils.humaniseCamelCase(((Field)field).getName());
            int colWidth = (Integer)columnWidths.get(((Field)field).getName());
            String format = "%1$-" + colWidth + "s";
            String output = String.format(format, displayName);
            sb.append(output);
            sb.append("|");
        }
        sb.append("\n");
        sb.append("|");
        for (AccessibleObject field : fields) {
            int colWidth = (Integer)columnWidths.get(((Field)field).getName());
            for (int i = 0; i < colWidth; ++i) {
                sb.append("-");
            }
            sb.append("+");
        }
        sb.append("\n");
        for (Object o : collection) {
            sb.append("|");
            for (AccessibleObject field : fields) {
                fieldValue = null;
                try {
                    fieldValue = ((Field)field).get(o);
                }
                catch (IllegalAccessException ex) {
                    throw new InternalError("Unexpected IllegalAccessException: " + ex.getMessage());
                }
                int colWidth = (Integer)columnWidths.get(((Field)field).getName());
                boolean number = Number.class.isAssignableFrom(((Field)field).getType());
                String leftJustified = number ? "" : "-";
                String format = "%1$" + leftJustified + colWidth + "s";
                String output = String.format(format, fieldValue).replace("\n", "\\n");
                if (output.length() > colWidth) {
                    output = output.substring(0, colWidth - 3) + "...";
                }
                sb.append(output);
                sb.append("|");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static <T> Class<T> getFirstObjectType(Collection<T> c) {
        for (T o : c) {
            if (o == null) continue;
            return o.getClass();
        }
        return null;
    }

    public static String getDisplayableValue(Displayable displayable) {
        return displayable == null ? null : displayable.getDisplayValue();
    }

    public static String formatAmountSuffix(int amt, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(amt);
        sb.append(' ');
        sb.append(suffix);
        if (amt != 1) {
            sb.append('s');
        }
        return sb.toString();
    }

    private FormattingUtils() {
    }
}

