/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.application;

import com.anahata.util.config.internal.AnahataUtilConfig;
import com.anahata.util.plaf.OSUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JWSUtils {
    private static final Logger log = LoggerFactory.getLogger(JWSUtils.class);
    private static final String JNLP_SYS_PROP_PREFFIX = "jnlp.";
    @Inject
    private AnahataUtilConfig config;

    public static String getSystemProperty(String key) {
        key = JWSUtils.isJavaWebStart() ? JNLP_SYS_PROP_PREFFIX + key : key;
        return System.getProperty(key);
    }

    public String getApplicationURL() {
        return this.getApplicationURL(this.config.getNonJwsApplicationUrl());
    }

    public String getApplicationHost() {
        String appURL = this.getApplicationURL();
        try {
            URL url = new URL(appURL);
            return url.getHost();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getApplicationPort() {
        String appURL = this.getApplicationURL();
        try {
            URL url = new URL(appURL);
            return url.getPort();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getApplicationProtocol() {
        String appURL = this.getApplicationURL();
        try {
            URL url = new URL(appURL);
            return url.getProtocol();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getApplicationURL(String nonJwsApplicationURL) {
        if (JWSUtils.isJavaWebStart()) {
            try {
                BasicService bs = (BasicService)ServiceManager.lookup((String)BasicService.class.getName());
                String codeBase = bs.getCodeBase().toString();
                String url = codeBase.substring(0, codeBase.indexOf("/webstart"));
                return url;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        log.debug("Running in non JNLP environment");
        return nonJwsApplicationURL;
    }

    public String getApplicationContextPath() {
        String base = this.getApplicationURL();
        String[] comps = base.split("/");
        return comps[comps.length - 1];
    }

    public static boolean isJavaWebStart() {
        boolean jnlpAware = ServiceManager.getServiceNames() != null;
        return jnlpAware;
    }

    public static void relaunchApplication() throws UnavailableServiceException, IOException {
        JWSUtils.relaunchApplication("launch.jnlp");
    }

    public static void relaunchApplication(String jnlpFileName) throws UnavailableServiceException, IOException {
        BasicService bs = (BasicService)ServiceManager.lookup((String)BasicService.class.getName());
        String codeBase = bs.getCodeBase().toString();
        String javaHome = System.getProperty("java.home");
        String executable = "javaws";
        if (OSUtils.isWindows()) {
            executable = executable + ".exe";
        }
        File f = new File(javaHome);
        f = new File(f, "bin");
        f = new File(f, executable);
        String url = codeBase + jnlpFileName;
        log.info("Relaunching Application, url={} codeBase={}", (Object)url, (Object)codeBase);
        ProcessBuilder pb = new ProcessBuilder(f.getAbsolutePath(), url);
        pb.start();
    }
}

