/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XMLUtils {
    public static String format(Node node) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(node);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            return xmlString;
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Document DOMParseXML(InputStream is) throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        return XMLUtils.DOMParseXML(is, false);
    }

    public static Document DOMParseXML(InputStream is, boolean namespaceAware) throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        return XMLUtils.getDocumentBuilder(namespaceAware).parse(is);
    }

    private static DocumentBuilder getDocumentBuilder(boolean namespaceAware) throws ParserConfigurationException {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setNamespaceAware(namespaceAware);
        return f.newDocumentBuilder();
    }

    public static String getNodeText(Node root, String path) {
        String s = "";
        Node n = XMLUtils.getNode(root, path);
        if (n != null) {
            s = XMLUtils.getTextContent(n);
        }
        return s;
    }

    public static String getTextContent(Node node) {
        String s = null;
        if (node.getNodeType() == 3) {
            s = s + node.getNodeValue();
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 3) continue;
            s = s == null || s.length() == 0 ? n.getNodeValue() : s + " " + n.getNodeValue();
        }
        return s;
    }

    public static Node getNode(Node root, String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] nodeNames = path.split("/");
        Node start = root;
        Node node = null;
        for (int i = 0; i < nodeNames.length; ++i) {
            node = XMLUtils.findNode(start, nodeNames[i]);
            if (node == null) {
                return null;
            }
            start = node;
        }
        return node;
    }

    private static Node findNode(Node root, String name) {
        if (name.equals(root.getNodeName())) {
            return root;
        }
        NodeList list = root.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (!name.equals(n.getNodeName())) continue;
            return n;
        }
        return null;
    }

    private XMLUtils() {
    }
}

