/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.transport.rpc.client;

import com.anahata.util.cdi.Cdi;
import com.anahata.util.transport.rpc.RcpError;
import com.anahata.util.transport.rpc.Rpc;
import com.anahata.util.transport.rpc.RpcStreamer;
import com.anahata.util.transport.rpc.client.RpcClientTransport;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RpcInvocationHandler.class);
    private URL url;
    private Class clazz;
    private RpcClientTransport transport;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        log.debug("RpcInvocationHandler entry {} {}.{} ", new Object[]{method.getReturnType(), method.getDeclaringClass().getSimpleName(), method.getName()});
        if (method.getDeclaringClass().equals(Object.class)) {
            return method.invoke((Object)this, args);
        }
        Rpc req = new Rpc(this.clazz, method, args);
        RpcStreamer streamer = Cdi.get(RpcStreamer.class, new Annotation[0]);
        long ts = System.currentTimeMillis();
        Object resp = this.transport.sendReceive(streamer, this.url, req);
        ts = System.currentTimeMillis() - ts;
        log.debug("{} ms full round trip for {} ", (Object)ts, (Object)method);
        if (resp instanceof RcpError) {
            ((RcpError)resp).doThrow();
        }
        return resp;
    }

    @ConstructorProperties(value={"url", "clazz", "transport"})
    public RpcInvocationHandler(URL url, Class clazz, RpcClientTransport transport) {
        this.url = url;
        this.clazz = clazz;
        this.transport = transport;
    }
}

