/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.math;

import com.anahata.util.lang.Nvl;
import java.math.BigDecimal;
import java.text.NumberFormat;
import org.apache.commons.lang3.Validate;

public class BigDecimalUtils {
    public static final BigDecimal TEN = new BigDecimal(10);
    public static final BigDecimal HUNDRED = new BigDecimal(100);
    public static final BigDecimal THOUSAND = new BigDecimal(1000);

    public static BigDecimal sum(BigDecimal ... bds) {
        Validate.notNull((Object)bds);
        BigDecimal ret = BigDecimal.ZERO;
        for (BigDecimal bd : bds) {
            ret = ret.add(Nvl.nvl(bd));
        }
        return ret;
    }

    public static boolean gt(BigDecimal d1, BigDecimal d2) {
        return Nvl.nvl(d1).compareTo(Nvl.nvl(d2)) > 0;
    }

    public static boolean ge(BigDecimal d1, BigDecimal d2) {
        return Nvl.nvl(d1).compareTo(Nvl.nvl(d2)) >= 0;
    }

    public static boolean lt(BigDecimal d1, BigDecimal d2) {
        return Nvl.nvl(d1).compareTo(Nvl.nvl(d2)) < 0;
    }

    public static boolean le(BigDecimal d1, BigDecimal d2) {
        return Nvl.nvl(d1).compareTo(Nvl.nvl(d2)) <= 0;
    }

    public static String formatCurrency(BigDecimal bd) {
        if (bd == null) {
            return "";
        }
        return NumberFormat.getCurrencyInstance().format(bd);
    }

    public static String formatCurrencyShort(BigDecimal bd) {
        if (bd == null) {
            return "";
        }
        String val = NumberFormat.getCurrencyInstance().format(bd);
        if (val.endsWith(".00")) {
            val = val.substring(0, val.length() - 3);
        }
        return val;
    }

    private BigDecimalUtils() {
    }
}

