/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.lang;

import java.math.BigDecimal;
import org.apache.commons.lang3.Validate;

public final class AnahataNumberUtils {
    public static boolean isAssignableToNumber(Class<? extends Number> numClass, String value) {
        Validate.notNull(numClass);
        if (value == null) {
            return true;
        }
        try {
            if (Integer.class.isAssignableFrom(numClass)) {
                Integer.valueOf(value);
            } else if (Long.class.isAssignableFrom(numClass)) {
                Long.valueOf(value);
            } else if (Float.class.isAssignableFrom(numClass)) {
                Float.valueOf(value);
            } else if (Double.class.isAssignableFrom(numClass)) {
                Double.valueOf(value);
            } else if (BigDecimal.class.isAssignableFrom(numClass)) {
                BigDecimal val = new BigDecimal(value);
            } else {
                throw new IllegalArgumentException("Unknown class type: " + numClass.getName());
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static BigDecimal multiply(BigDecimal value, Integer multiplicand, int scale) {
        if (value == null || multiplicand == null) {
            return null;
        }
        return value.multiply(new BigDecimal(multiplicand)).setScale(scale);
    }

    public static BigDecimal divide(BigDecimal value, Integer divisor, int scale) {
        if (value == null || divisor == null) {
            return null;
        }
        return value.divide(new BigDecimal(divisor)).setScale(scale, 4);
    }

    private AnahataNumberUtils() {
    }
}

