/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.date;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public final class DateUtil {
    public static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
        long diff = date2.getTime() - date1.getTime();
        return timeUnit.convert(diff, TimeUnit.MILLISECONDS);
    }

    public static Date toDate(@NonNull LocalDate localDate) {
        if (localDate == null) {
            throw new NullPointerException("localDate");
        }
        Instant instant = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static Date toNextDayDate(@NonNull LocalDate localDate) {
        if (localDate == null) {
            throw new NullPointerException("localDate");
        }
        Instant instant = localDate.plusDays(1L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static Calendar toCalendar(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal;
    }

    private DateUtil() {
    }
}

