/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.compress;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getString(@NonNull byte[] zipFile, @NonNull String suffix) {
        if (zipFile == null) {
            throw new NullPointerException("zipFile");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix");
        }
        try (ZipInputStream stream = new ZipInputStream(new ByteArrayInputStream(zipFile));){
            ZipEntry entry;
            do {
                if ((entry = stream.getNextEntry()) == null) return null;
            } while (!entry.getName().endsWith(suffix));
            String string = new String(IOUtils.toByteArray((InputStream)stream));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] replaceString(@NonNull byte[] zipFile, @NonNull String suffix, @NonNull String value) {
        if (zipFile == null) {
            throw new NullPointerException("zipFile");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipInputStream istream = new ZipInputStream(new ByteArrayInputStream(zipFile));
             ZipOutputStream ostream = new ZipOutputStream(baos);){
            ZipEntry entry;
            byte[] buf = new byte[1024];
            while ((entry = istream.getNextEntry()) != null) {
                int len;
                if (entry.getName().endsWith(suffix)) {
                    ZipEntry newEntry = new ZipEntry(entry.getName());
                    ostream.putNextEntry(newEntry);
                    ostream.write(value.getBytes());
                    continue;
                }
                ostream.putNextEntry(entry);
                while ((len = istream.read(buf)) > 0) {
                    ostream.write(buf, 0, len);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public static File compressFile(InputStream in, File directory, String fileName, String actualFileExtn) throws IOException {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String path = fileName + ".zip";
        byte[] buffer = new byte[1024];
        File filedst = new File(directory, path);
        try (FileOutputStream dest = new FileOutputStream(filedst);
             ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(dest));){
            int length;
            zip.setMethod(8);
            zip.setLevel(9);
            zip.putNextEntry(new ZipEntry(fileName + actualFileExtn));
            while ((length = in.read(buffer)) > 0) {
                zip.write(buffer, 0, length);
            }
        }
        return filedst;
    }

    private ZipUtils() {
    }
}

