/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.redundant;

import com.anahata.util.progress.ProgressListener;
import com.anahata.util.redundant.RedundantTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialTask<T>
extends RedundantTask<T>
implements ProgressListener {
    private static final Logger log = LoggerFactory.getLogger(SequentialTask.class);

    public SequentialTask(ExecutorService executorService) {
        super(executorService);
    }

    public SequentialTask(ExecutorService executorService, ProgressListener pl) {
        super(executorService, pl);
    }

    @Override
    protected void execute() {
        log.debug("Sequential task. execute():");
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (Callable callable : SequentialTask.this.getCallables()) {
                    try {
                        log.debug("Sequential Task Executing: {}", callable);
                        Object result = callable.call();
                        SequentialTask.this.suceeded(result);
                        return;
                    }
                    catch (Exception e) {
                        log.debug("Sequential Task registering error: {}", (Throwable)e);
                        SequentialTask.this.registerError(e);
                        log.debug("Sequential Task finished registering error: {}", (Throwable)e);
                    }
                }
                log.debug("Sequential Task calling fail() after attempting : {} callables", (Object)SequentialTask.this.getCallables().size());
                SequentialTask.this.fail();
                log.debug("Sequential Task finished calling fail() after attempting : {} callables", (Object)SequentialTask.this.getCallables().size());
            }
        };
        log.debug("Sequential task execute() submitting single runnable {}", (Object)r);
        this.submit(r);
        log.debug("Finished Sequential task execute() ");
    }
}

