/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.populate;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.Random;

public final class PopulateUtils {
    public static <T> T newInstanceMockFields(Class<T> c, String suffix) throws Exception {
        T ret = c.newInstance();
        PopulateUtils.setFieldsWithMockValues(ret, suffix);
        return ret;
    }

    public static void setFieldsWithMockValues(Object o, String suffix) throws Exception {
        for (Field f : o.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            f.set(o, PopulateUtils.getRandomValue(f.getType(), f.getName(), suffix));
        }
    }

    public static <T> T getRandomValue(Class<T> c, String preffix, String suffix) throws Exception {
        preffix = preffix == null ? "" : preffix + "-";
        String string = suffix = suffix == null ? "" : suffix + "-";
        if (Number.class.isAssignableFrom(c)) {
            int value = new Random().nextInt(127);
            return c.getConstructor(String.class).newInstance(String.valueOf(value));
        }
        if (String.class.isAssignableFrom(c)) {
            return (T)(preffix + System.currentTimeMillis() + suffix);
        }
        if (Date.class.isAssignableFrom(c)) {
            return (T)new Date();
        }
        if (Boolean.class.isAssignableFrom(c)) {
            return (T)(Math.random() > 0.5 ? Boolean.TRUE : Boolean.FALSE);
        }
        return null;
    }

    private PopulateUtils() {
    }
}

