/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.plaf.win;

import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowsShareUtils {
    private static final Logger log = LoggerFactory.getLogger(WindowsShareUtils.class);

    public static Boolean createSharedFolder(String ipaddress, String shareName, File file) throws HeadlessException, IOException {
        if (!WindowsShareUtils.checkIfShareExists(ipaddress, shareName)) {
            String filePath = file.getAbsolutePath();
            try {
                String line = String.format("net share %s=\"%s\" /GRANT:Everyone,FULL", shareName, filePath);
                log.debug("Executing {}", (Object)line);
                CommandLine cmdLine = CommandLine.parse((String)line);
                DefaultExecutor executor = new DefaultExecutor();
                int exitValue = executor.execute(cmdLine);
                log.debug("Exit value " + exitValue);
                return true;
            }
            catch (Exception e) {
                log.warn(e.getMessage());
                return false;
            }
        }
        return null;
    }

    public static boolean checkIfShareExists(String ipaddress, String shareName) throws IOException {
        String line2;
        String l = "net view \\\\" + ipaddress;
        Process process2 = Runtime.getRuntime().exec(l);
        BufferedReader is2 = new BufferedReader(new InputStreamReader(process2.getInputStream()));
        StringBuilder str = new StringBuilder(" ");
        while ((line2 = is2.readLine()) != null) {
            str.append(line2.trim()).append(" ");
        }
        return str.toString().contains(" " + shareName + " ");
    }

    private WindowsShareUtils() {
    }
}

