/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging.slf4j;

import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;

public final class ConstraintLogger {
    public static void logConstraints(Logger log, Throwable t) {
        log.error("Exception thrown", t);
        Throwable next = t;
        ConstraintLogger.logConstraintViolationException(log, t);
        while (next.getCause() != null) {
            next = next.getCause();
            ConstraintLogger.logConstraintViolationException(log, next);
        }
    }

    private static void logConstraintViolationException(Logger log, Throwable t) {
        if (t instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)t;
            for (Object o : cve.getConstraintViolations()) {
                log.error("Constraint violation: {}", o);
            }
        }
    }

    private ConstraintLogger() {
    }
}

