/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.error;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.anahata.util.config.AboutConfig;
import com.anahata.util.env.ApplicationEnvironment;
import com.anahata.util.net.InetUtils;
import com.anahata.util.plaf.RuntimeUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class ErrorDetail {
    private String applicationName;
    private String applicationVersion;
    private Date created;
    private String appUserName;
    private String appUserEmail;
    private InetAddress localIpAddress;
    private String externalIpAddress;
    private String message;
    private List<ILoggingEvent> events;
    private List<byte[]> screenshots = new ArrayList<byte[]>();
    private ApplicationEnvironment applicationEnv;
    private String device;
    private String javaVendor;
    private String javaVersion;
    private String javaFxVersion;
    private String osName;
    private String osVersion;
    private String osArchitecture;
    private String userName;
    private String userHome;
    private String userWorking;
    private String memStats = RuntimeUtils.getMemoryStats();
    private Throwable throwable;
    private String userComments = null;
    private boolean sendScreenshot = true;

    public boolean canSendScreenshot() {
        return !this.screenshots.isEmpty() && this.sendScreenshot;
    }

    private ErrorDetail() {
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getAppUserName() {
        return this.appUserName;
    }

    public String getAppUserEmail() {
        return this.appUserEmail;
    }

    public InetAddress getLocalIpAddress() {
        return this.localIpAddress;
    }

    public String getExternalIpAddress() {
        return this.externalIpAddress;
    }

    public String getMessage() {
        return this.message;
    }

    public List<ILoggingEvent> getEvents() {
        return this.events;
    }

    public List<byte[]> getScreenshots() {
        return this.screenshots;
    }

    public ApplicationEnvironment getApplicationEnv() {
        return this.applicationEnv;
    }

    public String getDevice() {
        return this.device;
    }

    public String getJavaVendor() {
        return this.javaVendor;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJavaFxVersion() {
        return this.javaFxVersion;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getOsArchitecture() {
        return this.osArchitecture;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserHome() {
        return this.userHome;
    }

    public String getUserWorking() {
        return this.userWorking;
    }

    public String getMemStats() {
        return this.memStats;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getUserComments() {
        return this.userComments;
    }

    public boolean isSendScreenshot() {
        return this.sendScreenshot;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setAppUserName(String appUserName) {
        this.appUserName = appUserName;
    }

    public void setAppUserEmail(String appUserEmail) {
        this.appUserEmail = appUserEmail;
    }

    public void setLocalIpAddress(InetAddress localIpAddress) {
        this.localIpAddress = localIpAddress;
    }

    public void setExternalIpAddress(String externalIpAddress) {
        this.externalIpAddress = externalIpAddress;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setEvents(List<ILoggingEvent> events) {
        this.events = events;
    }

    public void setScreenshots(List<byte[]> screenshots) {
        this.screenshots = screenshots;
    }

    public void setApplicationEnv(ApplicationEnvironment applicationEnv) {
        this.applicationEnv = applicationEnv;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public void setJavaVendor(String javaVendor) {
        this.javaVendor = javaVendor;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public void setJavaFxVersion(String javaFxVersion) {
        this.javaFxVersion = javaFxVersion;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public void setOsArchitecture(String osArchitecture) {
        this.osArchitecture = osArchitecture;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserHome(String userHome) {
        this.userHome = userHome;
    }

    public void setUserWorking(String userWorking) {
        this.userWorking = userWorking;
    }

    public void setMemStats(String memStats) {
        this.memStats = memStats;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public void setUserComments(String userComments) {
        this.userComments = userComments;
    }

    public void setSendScreenshot(boolean sendScreenshot) {
        this.sendScreenshot = sendScreenshot;
    }

    public static class Builder {
        private ErrorDetail target = new ErrorDetail();

        public Builder about(AboutConfig config, String device) {
            return this.applicationName(config.getAppName()).applicationVersion(config.getBuildUID()).message("[" + (Object)((Object)config.getEnvironment()) + "][" + config.getAppName() + "][" + device + "] Encountered Errors").device(device).applicationEnv(config.getEnvironment());
        }

        public Builder applicationName(String applicationName) {
            this.target.applicationName = applicationName;
            return this;
        }

        public Builder applicationVersion(String applicationVersion) {
            this.target.applicationVersion = applicationVersion;
            return this;
        }

        public Builder message(String message) {
            this.target.message = message;
            return this;
        }

        public Builder created(Date created) {
            this.target.created = created;
            return this;
        }

        public Builder appUserName(String username) {
            Validate.notNull((Object)username);
            this.target.appUserName = username;
            return this;
        }

        public Builder appUserEmail(String email) {
            Validate.notNull((Object)email);
            this.target.appUserEmail = email;
            return this;
        }

        public Builder localIpAddress(InetAddress localIpAddress) {
            Validate.notNull((Object)localIpAddress);
            this.target.localIpAddress = localIpAddress;
            return this;
        }

        public Builder externalIpAddress(String externalIpAddress) {
            Validate.notNull((Object)externalIpAddress);
            this.target.externalIpAddress = externalIpAddress;
            return this;
        }

        public Builder events(List<ILoggingEvent> events) {
            Validate.notNull(events);
            this.target.events = events;
            Collections.reverse(this.target.events);
            return this;
        }

        public Builder screenshot(byte[] screenshot) {
            Validate.notNull((Object)screenshot);
            this.target.screenshots.add(screenshot);
            return this;
        }

        public Builder applicationEnv(ApplicationEnvironment applicationEnv) {
            Validate.notNull((Object)((Object)applicationEnv));
            this.target.applicationEnv = applicationEnv;
            return this;
        }

        public Builder device(String device) {
            Validate.notNull((Object)device);
            this.target.device = device;
            return this;
        }

        public Builder userComments(String userComments) {
            Validate.notNull((Object)userComments);
            this.target.userComments = userComments;
            return this;
        }

        public Builder throwable(Throwable throwable) {
            Validate.notNull((Object)throwable);
            this.target.throwable = throwable;
            return this;
        }

        public Builder javaVendor(String javaVendor) {
            Validate.notNull((Object)javaVendor);
            this.target.javaVendor = javaVendor;
            return this;
        }

        public Builder javaVersion(String javaVersion) {
            Validate.notNull((Object)javaVersion);
            this.target.javaVersion = javaVersion;
            return this;
        }

        public Builder javaFxVersion(String javaFxVersion) {
            Validate.notNull((Object)javaFxVersion);
            this.target.javaFxVersion = javaFxVersion;
            return this;
        }

        public Builder osName(String osName) {
            Validate.notNull((Object)osName);
            this.target.osName = osName;
            return this;
        }

        public Builder osVersion(String osVersion) {
            Validate.notNull((Object)osVersion);
            this.target.osVersion = osVersion;
            return this;
        }

        public Builder osArchitecture(String osArchitecture) {
            Validate.notNull((Object)osArchitecture);
            this.target.osArchitecture = osArchitecture;
            return this;
        }

        public Builder userName(String userName) {
            Validate.notNull((Object)userName);
            this.target.userName = userName;
            return this;
        }

        public Builder userHome(String userHome) {
            Validate.notNull((Object)userHome);
            this.target.userHome = userHome;
            return this;
        }

        public Builder userWorking(String userWorking) {
            Validate.notNull((Object)userWorking);
            this.target.userWorking = userWorking;
            return this;
        }

        public Builder osDetails() {
            this.target.javaVendor = System.getProperty("java.vendor");
            this.target.javaVersion = System.getProperty("java.version");
            this.target.javaFxVersion = System.getProperty("javafx.runtime.version");
            this.target.osName = System.getProperty("os.name");
            this.target.osVersion = System.getProperty("os.version");
            this.target.osArchitecture = System.getProperty("os.arch");
            this.target.userName = System.getProperty("user.name");
            this.target.userHome = System.getProperty("user.home");
            this.target.userWorking = System.getProperty("user.dir");
            try {
                this.target.localIpAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                this.target.localIpAddress = null;
            }
            this.target.externalIpAddress = InetUtils.getExternalIpAddress();
            return this;
        }

        public ErrorDetail build() {
            if (this.target.created == null) {
                this.target.created = new Date();
            }
            return this.target;
        }
    }
}

