/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.transport.rpc.client.impl;

import com.anahata.util.application.JWSUtils;
import com.anahata.util.transport.rpc.Rpc;
import com.anahata.util.transport.rpc.RpcStreamer;
import com.anahata.util.transport.rpc.client.RpcClientTransport;
import com.anahata.util.transport.rpc.client.impl.RpcCredentialsProvider;
import java.io.IOException;
import java.net.URL;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import lombok.NonNull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CommonsRpcClientTransport
implements RpcClientTransport {
    private static final Logger log = LoggerFactory.getLogger(CommonsRpcClientTransport.class);
    @Inject
    private JWSUtils jwsUtils;
    private CloseableHttpClient httpClient;
    private HttpHost targetHost;
    @Inject
    @RpcCredentialsProvider
    private Instance<CredentialsProvider> credentialsProviderFactory;

    @PostConstruct
    public void init() {
        this.targetHost = new HttpHost(this.jwsUtils.getApplicationHost(), this.jwsUtils.getApplicationPort(), this.jwsUtils.getApplicationProtocol());
        this.httpClient = HttpClients.custom().setRetryHandler(null).setMaxConnPerRoute(20).build();
    }

    public CloseableHttpResponse execute(HttpUriRequest method) throws IOException {
        CredentialsProvider credentialsProvider;
        log.trace("executing {}", (Object)method);
        CredentialsProvider credentialsProvider2 = credentialsProvider = this.credentialsProviderFactory.isUnsatisfied() ? null : (CredentialsProvider)this.credentialsProviderFactory.get();
        if (credentialsProvider == null) {
            log.info("No credentials provider found via CDI @RpcCredentialsProvider");
        }
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(this.targetHost, (AuthScheme)basicAuth);
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider(credentialsProvider);
        context.setAuthCache((AuthCache)authCache);
        context.getAuthCache().put(this.targetHost, (AuthScheme)basicAuth);
        CloseableHttpResponse resp = this.getHttpClient().execute(method, (HttpContext)context);
        StatusLine sl = resp.getStatusLine();
        if (sl.getStatusCode() == 401) {
            resp.close();
            if (credentialsProvider != null) {
                credentialsProvider.clear();
                return this.execute(method);
            }
            throw new IOException("HTTP Unauthorized and no credentials provider has been set on" + this);
        }
        return resp;
    }

    @Override
    public Object sendReceive(@NonNull RpcStreamer streamer, @NonNull URL url, @NonNull Rpc req) throws Exception {
        if (streamer == null) {
            throw new NullPointerException("streamer");
        }
        if (url == null) {
            throw new NullPointerException("url");
        }
        if (req == null) {
            throw new NullPointerException("req");
        }
        byte[] barr = streamer.stream(req);
        HttpPost post = new HttpPost(url.toURI());
        post.setEntity((HttpEntity)new ByteArrayEntity(barr));
        post.addHeader("AnahataCompression", streamer.getCompressionType().name());
        post.addHeader("AnahataSerialization", streamer.getSerializationType().name());
        Throwable throwable = null;
        try (CloseableHttpResponse res = this.execute((HttpUriRequest)post);){
            StatusLine sl = res.getStatusLine();
            if (sl.getStatusCode() == 200) {
                Object t = streamer.receiveStreaming(res.getEntity().getContent());
                return t;
            }
            try {
                throw new Exception("Server retured " + sl.getStatusCode() + " " + sl.getReasonPhrase() + " for url" + url);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpHost getTargetHost() {
        return this.targetHost;
    }
}

