/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging.slf4j;

import com.anahata.util.logging.slf4j.ErrorStreamMonitor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ErrorMonitoringPrintStream
extends PrintStream {
    private static final Logger log = LoggerFactory.getLogger((String)"System.err");
    private boolean collecting = false;
    private Deque<String> buffer = new ConcurrentLinkedDeque<String>();
    private long lastLogTs;
    private ErrorStreamMonitor monitor;

    ErrorMonitoringPrintStream() {
        super(new NullOutputStream());
    }

    @Override
    public void println() {
    }

    @Override
    public void println(boolean x) {
        this.process(String.valueOf(x));
    }

    @Override
    public void println(char x) {
        this.process(String.valueOf(x));
    }

    @Override
    public void println(int x) {
        this.process(String.valueOf(x));
    }

    @Override
    public void println(long x) {
        this.process(String.valueOf(x));
    }

    @Override
    public void println(float x) {
        this.process(String.valueOf(x));
    }

    @Override
    public void println(double x) {
        this.process(String.valueOf(x));
    }

    @Override
    public void println(char[] x) {
        this.process(String.valueOf(x));
    }

    @Override
    public void println(String x) {
        this.process(String.valueOf(x));
    }

    @Override
    public void println(Object x) {
        this.process(String.valueOf(x));
    }

    public List<String> getBufferAndReset() {
        ArrayList<String> bufferCopy = new ArrayList<String>(this.buffer);
        this.buffer.clear();
        return bufferCopy;
    }

    private void process(String value) {
        if (this.isPrintStackTrace()) {
            this.buffer.add(value);
        } else if (this.isWarning(value)) {
            log.warn(value);
        } else {
            log.error(value);
        }
    }

    private boolean isWarning(String value) {
        return StringUtils.startsWith((CharSequence)value, (CharSequence)"WARNING:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPrintStackTrace() {
        this.lastLogTs = System.currentTimeMillis();
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        boolean found = false;
        for (StackTraceElement ste : stes) {
            if (!Throwable.class.getName().equals(ste.getClassName()) || !"printStackTrace".equals(ste.getMethodName())) continue;
            found = true;
            break;
        }
        if (!this.collecting && found) {
            this.collecting = true;
            this.monitor = new ErrorStreamMonitor(this);
            this.monitor.start();
        }
        if (this.collecting && !found) {
            this.collecting = false;
            ErrorStreamMonitor errorStreamMonitor = this.monitor;
            synchronized (errorStreamMonitor) {
                this.monitor.notify();
            }
        }
        return found;
    }

    boolean isCollecting() {
        return this.collecting;
    }

    void setCollecting(boolean collecting) {
        this.collecting = collecting;
    }

    long getLastLogTs() {
        return this.lastLogTs;
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

