/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.anahata.util.io.FileModificationListener;
import com.anahata.util.io.FileMonitor;
import com.anahata.util.lang.ResourceUtils;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.tika.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogbackReloader {
    private static final Logger log = LoggerFactory.getLogger(LogbackReloader.class);
    static File tempFile;

    public static synchronized void showEditor() throws Exception {
        if (tempFile == null) {
            tempFile = File.createTempFile("logback", ".xml");
            log.debug("tempFile at {}", (Object)tempFile);
            IOUtils.copy((InputStream)ResourceUtils.getResource("/logback.xml").openStream(), (OutputStream)new FileOutputStream(tempFile));
            FileMonitor fileMonitor = new FileMonitor(tempFile, new FileModificationListener(){

                @Override
                public void fileModified(FileMonitor monitor, Date prevLastModified, Date newLastModified) {
                    LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                    try {
                        JoranConfigurator configurator = new JoranConfigurator();
                        configurator.setContext((Context)loggerContext);
                        loggerContext.reset();
                        configurator.doConfigure(tempFile);
                    }
                    catch (JoranException je) {
                        // empty catch block
                    }
                    StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
                }
            });
        }
        Desktop.getDesktop().edit(tempFile);
    }
}

