/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.AppenderBase;
import com.anahata.util.cdi.Cdi;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ErrorEventAppender
extends AppenderBase<ILoggingEvent> {
    private static final Logger log = LoggerFactory.getLogger(ErrorEventAppender.class);
    private int bufferSize = 300;
    private long errorTimeout = 300L;
    private String ignoreErrors;
    private List<String> ignoreErrorsList = new ArrayList<String>();
    private Deque<ILoggingEvent> logBuffer = new ConcurrentLinkedDeque<ILoggingEvent>();
    private long lastLogTs;
    private State state = State.SEARCHING;
    @Inject
    private Event<ErrorEventAppender> eventMonitor;

    protected void append(ILoggingEvent e) {
        this.lastLogTs = e.getTimeStamp();
        boolean errorOrHigher = e.getLevel().isGreaterOrEqual(Level.ERROR);
        this.logBuffer.addLast(e);
        if (this.logBuffer.size() > this.bufferSize) {
            this.logBuffer.removeFirst();
        }
        if (this.state == State.SEARCHING && errorOrHigher && !this.shouldIgnore(e)) {
            this.state = State.FOUND;
            try {
                Cdi.fireEvent((Object)this, new Annotation[0]);
            }
            catch (Exception ex) {
                log.warn("Could not find error event", (Throwable)ex);
            }
        }
        if (this.state == State.FOUND && !errorOrHigher) {
            this.state = State.SEARCHING;
        }
    }

    private boolean shouldIgnore(ILoggingEvent e) {
        boolean ignore = false;
        if (this.ignoreErrors != null) {
            System.out.println("Formatted message is " + e.getFormattedMessage());
            if (this.ignoreErrorsList.contains(e.getFormattedMessage())) {
                return true;
            }
            block0: for (IThrowableProxy itp = e.getThrowableProxy(); itp != null; itp = itp.getCause()) {
                for (StackTraceElementProxy ste : itp.getStackTraceElementProxyArray()) {
                    for (String err : this.ignoreErrorsList) {
                        if (!ste.toString().contains(err)) continue;
                        ignore = true;
                        break block0;
                    }
                }
            }
        }
        return ignore;
    }

    public synchronized List<ILoggingEvent> getLoggingEvents() {
        return new ArrayList<ILoggingEvent>(this.logBuffer);
    }

    public void setIgnoreErrors(String ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
        if (ignoreErrors != null) {
            String[] lines;
            for (String string : lines = ignoreErrors.split("\n")) {
                if ((string = string.trim()).isEmpty()) continue;
                this.ignoreErrorsList.add(string.trim());
            }
            System.out.println("ignoreErrorsList = " + this.ignoreErrorsList);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public long getErrorTimeout() {
        return this.errorTimeout;
    }

    public void setErrorTimeout(long errorTimeout) {
        this.errorTimeout = errorTimeout;
    }

    public String getIgnoreErrors() {
        return this.ignoreErrors;
    }

    Deque<ILoggingEvent> getLogBuffer() {
        return this.logBuffer;
    }

    long getLastLogTs() {
        return this.lastLogTs;
    }

    State getState() {
        return this.state;
    }

    void setState(State state) {
        this.state = state;
    }

    static enum State {
        SEARCHING,
        FOUND;

    }
}

