/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jpa.eclipselink;

import com.anahata.util.jpa.JPAPropertyUtils;
import com.anahata.util.jpa.JpaPropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.sessions.CopyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedCopyGroup
extends CopyGroup {
    private static final Logger log = LoggerFactory.getLogger(TypedCopyGroup.class);
    private List<Class> types;
    private final Set<String> allAtts = new HashSet<String>();

    public TypedCopyGroup(Class ... types) {
        this(true, types);
    }

    public TypedCopyGroup(boolean addAll, Class ... types) {
        Validate.notEmpty((Object[])types);
        this.types = Arrays.asList(types);
        for (Class c : types) {
            Map<String, JpaPropertyDescriptor> props = JPAPropertyUtils.describe(c);
            this.allAtts.addAll(props.keySet());
        }
        if (addAll) {
            log.trace("All Atts for {} are {}", (Object)types, this.allAtts);
            this.addAttributes(this.allAtts);
        }
    }

    public final void addAttributes(Collection<String> attributes) {
        Validate.notEmpty(attributes);
        for (String string : attributes) {
            this.addAttribute(string);
        }
    }

    public TypedCopyGroup getGroup(Attribute attribute) {
        Validate.isTrue((boolean)this.allAtts.contains(attribute.getName()), (String)("Cannot get CopyGroup for attribute " + attribute), (Object[])new Object[0]);
        return (TypedCopyGroup)super.getGroup(attribute.getName());
    }

    public void addAttribute(Attribute att) {
        this.addAttribute(att.getName());
    }

    public void addAttribute(String attribute) {
        Validate.notNull((Object)attribute);
        if (!attribute.contains(".")) {
            Validate.isTrue((boolean)this.allAtts.contains(attribute), (String)("Cannot add attribute " + attribute + " for types " + Arrays.asList(this.types) + " valid attributes are: " + this.allAtts), (Object[])new Object[0]);
        }
        super.addAttribute(attribute);
    }

    public void addAttribute(String s, CopyGroup copyGroup) {
        if (!(copyGroup instanceof TypedCopyGroup)) {
            throw new IllegalArgumentException("Any CopyGroups added should be of type typedCopyGroup");
        }
        super.addAttribute(s, copyGroup);
    }

    public <T extends TypedCopyGroup> T addAttribute(Attribute att, T typedCopyGroup) {
        return this.addAttribute(att.getName(), typedCopyGroup);
    }

    public <T extends TypedCopyGroup> T addAttribute(String attribute, T typedCopyGroup) {
        Validate.notNull((Object)attribute);
        Validate.notNull(typedCopyGroup);
        Validate.isTrue((boolean)this.allAtts.contains(attribute), (String)(((Object)((Object)this)).getClass().getSimpleName() + " cannot add attribute " + attribute + " for types " + Arrays.asList(this.types) + " valid attributes are: " + this.allAtts), (Object[])new Object[0]);
        HashSet<Class> supportedTypes = new HashSet<Class>();
        for (Class t : this.types) {
            JpaPropertyDescriptor jpd;
            Map<String, JpaPropertyDescriptor> props = JPAPropertyUtils.describe(t);
            if (!props.containsKey(attribute) || !(jpd = props.get(attribute)).isRelationship() && !jpd.isEmbedded()) continue;
            Class attributeType = jpd.getEntityType();
            supportedTypes.add(attributeType);
            for (Class typedCopyGroupType : typedCopyGroup.getTypes()) {
                if (!attributeType.isAssignableFrom(typedCopyGroupType)) continue;
                super.removeAttribute(attribute);
                super.addAttribute(attribute, typedCopyGroup);
                return typedCopyGroup;
            }
        }
        throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " Cannot add copygroup " + ((Object)typedCopyGroup).getClass().getSimpleName() + " for attribute " + attribute + " valid types for this attribute are:" + supportedTypes + " (or subclasses) specified copygroup represents types: " + typedCopyGroup.getTypes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int indent = 0;
        HashSet<TypedCopyGroup> allreadyPrinted = new HashSet<TypedCopyGroup>();
        this.toString(sb, indent, allreadyPrinted);
        return sb.toString();
    }

    private void appendType(StringBuilder sb) {
        sb.append("{");
        boolean first = true;
        for (Class currType : this.types) {
            if (!first) {
                sb.append(",");
            }
            sb.append(currType.getSimpleName());
            first = false;
        }
        sb.append("}:id=");
        sb.append(System.identityHashCode((Object)this));
        sb.append(" copies:");
        sb.append(this.getCopies().size());
    }

    public void toString(StringBuilder sb, int indent, Set<TypedCopyGroup> alreadyPrinted) {
        alreadyPrinted.add(this);
        this.appendType(sb);
        String padding = StringUtils.leftPad((String)"", (int)(indent += 2), (String)" ");
        ArrayList atts = new ArrayList(this.getAttributeNames());
        Collections.sort(atts);
        for (String s : atts) {
            sb.append("\n");
            sb.append(padding);
            sb.append("+");
            sb.append(s);
            TypedCopyGroup cg = (TypedCopyGroup)this.getGroup(s);
            if (cg == null) continue;
            sb.append(" = ");
            if (alreadyPrinted.contains((Object)cg)) {
                sb.append("Ref:");
                cg.appendType(sb);
                continue;
            }
            int newIndent = indent + s.length() + 4;
            cg.toString(sb, newIndent, alreadyPrinted);
        }
    }

    private TypedCopyGroup() {
    }

    public List<Class> getTypes() {
        return this.types;
    }

    public Set<String> getAllAtts() {
        return this.allAtts;
    }
}

