/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.html;

import com.anahata.util.html.SpanBuilder;
import org.apache.commons.lang3.Validate;

public final class HtmlBuilder {
    private String style;
    private StringBuilder body = new StringBuilder();

    public HtmlBuilder style(String style) {
        Validate.notNull((Object)style);
        this.style = style;
        return this;
    }

    public HtmlBuilder body(String value) {
        if (value == null) {
            return this;
        }
        this.body.append(value);
        return this;
    }

    public HtmlBuilder span(String value) {
        this.body.append(new SpanBuilder().value(value).build());
        return this;
    }

    public HtmlBuilder span(String style, String value) {
        this.body.append(new SpanBuilder().style(style).value(value).build());
        return this;
    }

    public HtmlBuilder pre(String value) {
        this.body.append("<pre>");
        this.body.append(value);
        this.body.append("</pre>");
        return this;
    }

    public HtmlBuilder br() {
        this.body.append("<br />");
        return this;
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head></head><body");
        this.appendStyle(sb, this.style);
        sb.append(">");
        sb.append((CharSequence)this.body);
        sb.append("</body></html>");
        return sb.toString();
    }

    private void appendStyle(StringBuilder sb, String styleValue) {
        if (styleValue != null) {
            sb.append(" style='");
            sb.append(styleValue);
            sb.append("'");
        }
    }
}

