/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.config;

import com.anahata.util.env.ApplicationEnvironment;
import com.anahata.util.props.StructuredProperties;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutConfig
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AboutConfig.class);
    private String appName;
    private String appOwner;
    private String appVersion;
    private String buildNumber;
    private Date buildTimestamp;
    private String formattedBuildTimestamp;
    private String buildUID;
    private String appTitle;
    private ApplicationEnvironment environment;
    private String baseUrl;

    public AboutConfig(Properties props, String ... prefixes) {
        Validate.notNull((Object)props);
        StructuredProperties sprops = new StructuredProperties(props, prefixes);
        this.appName = sprops.getString("application.name");
        this.appOwner = sprops.getString("application.owner", "");
        this.appVersion = sprops.getString("application.version");
        this.buildNumber = sprops.getString("application.build.number");
        String format = sprops.getString("application.build.timestamp.format");
        try {
            this.buildTimestamp = sprops.getDate("application.build.timestamp", format);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception parsion buildTimestamp with format, " + format + "." + " Does the pom of the project containing the properties being parsed" + " have a build/resources or build/testResources section?", e);
        }
        this.formattedBuildTimestamp = DateFormat.getDateTimeInstance(3, 2).format(this.buildTimestamp);
        String displayVersion = AboutConfig.displayVersion(this.appVersion);
        this.buildUID = displayVersion + " b" + this.buildNumber + " " + this.formattedBuildTimestamp;
        this.environment = sprops.getEnum(ApplicationEnvironment.class, "application.environment");
        this.appTitle = this.makeApplicationTitle();
        this.baseUrl = sprops.getString("application.home.page", null);
    }

    public static String displayVersion(String version) {
        String dver = "v" + version;
        if ((dver = dver.replace("-SNAPSHOT", "-Beta")).endsWith(".0")) {
            dver = dver.substring(0, dver.length() - 2);
        }
        if (dver.contains(".0-")) {
            dver = dver.replace(".0-", "-");
        }
        return dver;
    }

    private String makeApplicationTitle() {
        String applicationTitle = this.appName;
        String displayVersion = AboutConfig.displayVersion(this.appVersion);
        if (this.environment != ApplicationEnvironment.PROD) {
            applicationTitle = (Object)((Object)this.environment) + " " + applicationTitle;
            displayVersion = displayVersion + " b" + this.buildNumber;
        }
        applicationTitle = applicationTitle + " " + displayVersion;
        return applicationTitle;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppOwner() {
        return this.appOwner;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public Date getBuildTimestamp() {
        return this.buildTimestamp;
    }

    public String getFormattedBuildTimestamp() {
        return this.formattedBuildTimestamp;
    }

    public String getBuildUID() {
        return this.buildUID;
    }

    public String getAppTitle() {
        return this.appTitle;
    }

    public ApplicationEnvironment getEnvironment() {
        return this.environment;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    private AboutConfig() {
    }

    public String toString() {
        return "AboutConfig(appName=" + this.getAppName() + ", appOwner=" + this.getAppOwner() + ", appVersion=" + this.getAppVersion() + ", buildNumber=" + this.getBuildNumber() + ", buildTimestamp=" + this.getBuildTimestamp() + ", formattedBuildTimestamp=" + this.getFormattedBuildTimestamp() + ", buildUID=" + this.getBuildUID() + ", appTitle=" + this.getAppTitle() + ", environment=" + (Object)((Object)this.getEnvironment()) + ", baseUrl=" + this.getBaseUrl() + ")";
    }
}

