/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getString(@NonNull byte[] zipFile, @NonNull String suffix) {
        if (zipFile == null) {
            throw new NullPointerException("zipFile");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix");
        }
        try (ZipInputStream stream = new ZipInputStream(new ByteArrayInputStream(zipFile));){
            ZipEntry entry;
            do {
                if ((entry = stream.getNextEntry()) == null) return null;
            } while (!entry.getName().endsWith(suffix));
            String string = new String(IOUtils.toByteArray((InputStream)stream));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] replaceString(@NonNull byte[] zipFile, @NonNull String suffix, @NonNull String value) {
        if (zipFile == null) {
            throw new NullPointerException("zipFile");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipInputStream istream = new ZipInputStream(new ByteArrayInputStream(zipFile));
             ZipOutputStream ostream = new ZipOutputStream(baos);){
            ZipEntry entry;
            byte[] buf = new byte[1024];
            while ((entry = istream.getNextEntry()) != null) {
                int len;
                if (entry.getName().endsWith(suffix)) {
                    ZipEntry newEntry = new ZipEntry(entry.getName());
                    ostream.putNextEntry(newEntry);
                    ostream.write(value.getBytes());
                    continue;
                }
                ostream.putNextEntry(entry);
                while ((len = istream.read(buf)) > 0) {
                    ostream.write(buf, 0, len);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    /*
     * Exception decompiling
     */
    public static String compressFile(InputStream in, String location, String fileName, String actualFileExtn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ZipUtils() {
    }
}

