/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.lang;

import java.net.URL;
import org.apache.commons.lang3.Validate;

public final class ResourceUtils {
    public static URL getResource(String name) {
        Validate.notNull((Object)name);
        URL url = Thread.currentThread().getContextClassLoader().getResource(name);
        if (url == null) {
            url = ResourceUtils.class.getResource(name);
        }
        if (url == null) {
            url = ResourceUtils.class.getClassLoader().getResource(name);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(name);
        }
        return url;
    }

    public static URL getResource(String name, ClassLoader classLoader) {
        Validate.notNull((Object)name);
        Validate.notNull((Object)classLoader);
        URL url = classLoader.getResource(name);
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(name);
        }
        if (url == null) {
            url = ResourceUtils.class.getClassLoader().getResource(name);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(name);
        }
        return url;
    }

    private ResourceUtils() {
    }
}

