/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.ejb;

import com.anahata.util.ejb.ManagedParam;
import com.anahata.util.ejb.ManagedParams;
import com.anahata.util.jpa.JPAUtils;
import java.lang.annotation.Annotation;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
@ManagedParams
public abstract class AbstractManagedParamsInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @AroundInvoke
    public final Object intercept(InvocationContext ic) throws Exception {
        return this.intercept(this.getEntityManager(), ic);
    }

    public final Object intercept(EntityManager em, InvocationContext ic) throws Exception {
        this.log.trace("Considering " + ic.getMethod() + " ");
        if (ic.getParameters() == null || ic.getParameters().length == 0) {
            return ic.proceed();
        }
        ManagedParams methodLevelAnnotation = ic.getMethod().getAnnotation(ManagedParams.class);
        boolean manageAll = methodLevelAnnotation != null;
        Annotation[][] paramsAnnotations = ic.getMethod().getParameterAnnotations();
        Object[] params = ic.getParameters();
        Object[] managedParams = new Object[ic.getParameters().length];
        for (int i = 0; i < params.length; ++i) {
            Object o = params[i];
            if (o == null) continue;
            boolean attempt = false;
            LockModeType lockMode = LockModeType.NONE;
            Object[] paramAnnotations = paramsAnnotations[i];
            lockMode = methodLevelAnnotation != null ? methodLevelAnnotation.lockMode() : LockModeType.NONE;
            ManagedParam paramLevelAnnotation = null;
            for (Annotation annotation : paramAnnotations) {
                if (!(annotation instanceof ManagedParam)) continue;
                paramLevelAnnotation = (ManagedParam)annotation;
                lockMode = paramLevelAnnotation.lockMode();
            }
            boolean bl = attempt = manageAll || ArrayUtils.contains((Object[])paramAnnotations, ManagedParam.class);
            if (attempt) {
                this.log.trace("Converting to managed: {} with lock mode= {}", o, (Object)lockMode);
                managedParams[i] = JPAUtils.getManaged(em, o, lockMode);
                continue;
            }
            this.log.trace("Will not convert to managed: {}", o);
            managedParams[i] = o;
        }
        ic.setParameters(managedParams);
        return ic.proceed();
    }

    protected abstract EntityManager getEntityManager();
}

